% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/AllGenerics.R, R/plot_time.R
\docType{methods}
\name{plot_time}
\alias{plot_time}
\alias{plot_time-method}
\alias{plot_time,data.frame,numeric-method}
\alias{plot_time,matrix,numeric-method}
\title{Abundance vs Time Plot}
\usage{
plot_time(object, dates, ...)

\S4method{plot_time}{data.frame,numeric}(object, dates, calendar = get_calendar(), ...)

\S4method{plot_time}{matrix,numeric}(object, dates, calendar = get_calendar(), ...)
}
\arguments{
\item{object}{A \eqn{m \times p}{m x p} \code{numeric} \code{\link{matrix}} or
\code{\link{data.frame}} of count data (absolute frequencies giving the number of
individuals for each category, i.e. a contingency table). A \code{\link{data.frame}}
will be coerced to a \code{numeric} \code{matrix} via \code{\link[=data.matrix]{data.matrix()}}.}

\item{dates}{A \code{\link{numeric}} vector of dates.}

\item{...}{Further parameters to be passed to \code{\link[aion:plot]{aion::plot()}}.}

\item{calendar}{An \code{\link[aion:TimeScale-class]{aion::TimeScale}} object specifying the target
calendar (see \code{\link[aion:calendar]{aion::calendar()}}).}
}
\value{
\code{plot_time()} is called it for its side-effects: it results in a graphic
being displayed (invisibly returns \code{object}).
}
\description{
Produces an abundance \emph{vs} time diagram.
}
\examples{
## Data from Crema et al. 2016
data("merzbach", package = "folio")

## Coerce the merzbach dataset to a count matrix
## Keep only decoration types that have a maximum frequency of at least 50
keep <- apply(X = merzbach, MARGIN = 2, FUN = function(x) max(x) >= 50)
counts <- merzbach[, keep]

## Set dates
## We use the row names as time coordinates (roman numerals)
dates <- as.numeric(utils::as.roman(rownames(counts)))

## Plot abundance vs time
plot_time(counts, dates, calendar = NULL, ncol = 3, xlab = "Phases")
}
\author{
N. Frerebeau
}
\concept{plotting methods}
