% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/main.R
\name{eval_dlm_log_like}
\alias{eval_dlm_log_like}
\title{Auxiliary function for evaluating the prior density of a DLM}
\usage{
eval_dlm_log_like(theta, model, lin.pred = FALSE)
}
\arguments{
\item{theta}{Matrix: A matrix representing the set of parameter for which to evaluate the density. Its size should be n x t, where n is the number of latent states and t is the length of the time series;}

\item{model}{fitted_dlm: A fitted_dlm object.}

\item{lin.pred}{boolean: A flag indicating if theta represents the linear predictors.}
}
\value{
A scalar representing the log likelihood evaluated at theta.
}
\description{
Evaluates the prior density for a set of parameters theta in a DLM. The structure of the DLM is taken to be that of the fitted_dlm object passed as input.
}
\examples{

data <- c(AirPassengers)

level <- polynomial_block(rate = 1, order = 2, D = 0.95)
season <- harmonic_block(rate = 1, order = 2, period = 12, D = 0.975)

outcome <- Poisson(lambda = "rate", data = data)

fitted.data <- fit_model(level, season,
  AirPassengers = outcome
)
eval_dlm_log_like(fitted.data$mts, fitted.data)
}
\keyword{internal}
