% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/number_of_junctions.R
\name{number_of_junctions}
\alias{number_of_junctions}
\title{Calculate the average number of junctions}
\usage{
number_of_junctions(N = Inf, R = Inf, H_0 = 0.5, C = 1, t = 100)
}
\arguments{
\item{N}{Population Size}

\item{R}{Number of genetic markers}

\item{H_0}{Frequency of heterozygosity at t = 0}

\item{C}{Mean number of crossovers per meiosis (e.g. size in Morgan of the
chromosome)}

\item{t}{Time since admixture}
}
\value{
Estimated number of junctions at time t
}
\description{
Calculate the average number of junctions in a single chromosome
after t generations, provided information on the initial heterozygosity,
population size and the number of generations.
}
\examples{
jt <-  number_of_junctions(N = 100, R = 1000, H_0 = 0.5, C = 1, t = 1000)
jt2 <- number_of_junctions(N = 100, R = 1000, H_0 = 0.5, C = 1, t = 0:1000)
}
