% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/summ_rq.R
\name{summ.rq}
\alias{summ.rq}
\title{Quantile regression summaries with options}
\usage{
\method{summ}{rq}(
  model,
  scale = FALSE,
  confint = getOption("summ-confint", FALSE),
  ci.width = getOption("summ-ci.width", 0.95),
  se = c("nid", "rank", "iid", "ker", "boot"),
  boot.sims = 1000,
  boot.method = "xy",
  vifs = getOption("summ-vifs", FALSE),
  digits = getOption("jtools-digits", 2),
  pvals = getOption("summ-pvals", TRUE),
  n.sd = 1,
  center = FALSE,
  transform.response = FALSE,
  data = NULL,
  model.info = getOption("summ-model.info", TRUE),
  model.fit = getOption("summ-model.fit", TRUE),
  which.cols = NULL,
  ...
)
}
\arguments{
\item{model}{A \code{rq} model. At this time, \code{rqs} models (multiple \code{tau}
parameters) are not supported.}

\item{scale}{If \code{TRUE}, reports standardized regression
coefficients by scaling and mean-centering input data (the latter can be
changed via the \code{scale.only} argument). Default is \code{FALSE}.}

\item{confint}{Show confidence intervals instead of standard errors? Default
is \code{FALSE}.}

\item{ci.width}{A number between 0 and 1 that signifies the width of the
desired confidence interval. Default is \code{.95}, which corresponds
to a 95\% confidence interval. Ignored if \code{confint = FALSE}.}

\item{se}{One of "nid", "rank", "iid", "ker", or "boot". "nid" is default.
See \code{\link[quantreg:summary.rq]{quantreg::summary.rq()}} documentation for more about these options.}

\item{boot.sims}{If \code{se = "boot"}, the number of bootstrap replications to
perform. This is passed as the \code{R} argument to \code{boot.rq}}

\item{boot.method}{If \code{se = "boot"}, the type of bootstrapping method to
use. Default is "xy", but see \code{\link[quantreg:boot.rq]{quantreg::boot.rq()}} for more options.}

\item{vifs}{If \code{TRUE}, adds a column to output with variance inflation
factors (VIF). Default is \code{FALSE}.}

\item{digits}{An integer specifying the number of digits past the decimal to
report in the output. Default is 2. You can change the default number of
digits for all jtools functions with
\code{options("jtools-digits" = digits)} where digits is the desired
number.}

\item{pvals}{Show p values? If \code{FALSE}, these
are not printed. Default is \code{TRUE}.}

\item{n.sd}{If \code{scale = TRUE}, how many standard deviations should
predictors be divided by? Default is 1, though some suggest 2.}

\item{center}{If you want coefficients for mean-centered variables but don't
want to standardize, set this to \code{TRUE}. Note that setting this to
false does not affect whether \code{scale} mean-centers variables. Use
\code{scale.only} for that.}

\item{transform.response}{Should scaling/centering apply to response
variable? Default is \code{FALSE}.}

\item{data}{If you provide the data used to fit the model here, that data
frame is used to re-fit the model (if \code{scale} is \code{TRUE})
instead of the \code{\link[stats:model.frame]{stats::model.frame()}}
of the model. This is particularly useful if you have variable
transformations or polynomial terms specified in the formula.}

\item{model.info}{Toggles printing of basic information on sample size,
name of DV, and number of predictors.}

\item{model.fit}{Toggles printing of model fit statistics.}

\item{which.cols}{Developmental feature. By providing columns by name,
you can add/remove/reorder requested columns in the output. Not fully
supported, for now.}

\item{...}{Among other things, arguments are passed to \code{\link[=scale_mod]{scale_mod()}} or
\code{\link[=center_mod]{center_mod()}} when \code{center} or \code{scale} is \code{TRUE}.}
}
\description{
\code{summ()} prints output for a regression model in a fashion
similar to \code{summary()}, but formatted differently with more options.
}
\details{
This method implements most of the things I think most users would
asking \code{summary.rq} for. \code{hs}, \code{U}, and \code{gamma} are ignored.

Note that when using \code{se = "rank"}, there are no standard errors,
test statistics, or p values calculated.

About the R1 fit statistic: Described in Koenker & Machado (1999), this
offers an interpretation similar to R-squared in OLS regression. While you
could calculate R-squared for these models, it goes against the underlying
theoretical rationale for them. Koenker himself is not a big fan of R1
either, but it's something. See Koenker & Machado (1999) for more info.
}
\examples{

if (requireNamespace("quantreg")) {
 library(quantreg)
 data(engel)
 fitrq <- rq(income ~ foodexp, data = engel, tau = 0.5)
 summ(fitrq)
}


}
\references{
Koenker, R., & Machado, J. A. F. (1999). Goodness of fit and related
inference processes for quantile regression.
\emph{Journal of the American Statistical Association}, \emph{94}, 1296–1310.
https://doi.org/10.1080/01621459.1999.10473882
}
\seealso{
Other summ: 
\code{\link{summ.glm}()},
\code{\link{summ.lm}()},
\code{\link{summ.merMod}()},
\code{\link{summ.svyglm}()}
}
\concept{summ}
