% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/make_predictions.R
\name{make_predictions.merMod}
\alias{make_predictions.merMod}
\title{Generate predicted data for merMod models}
\usage{
\method{make_predictions}{merMod}(model, pred, pred.values = NULL,
  modx = NULL, modx.values = NULL, mod2 = NULL, mod2.values = NULL,
  centered = "all", data = NULL, plot.points = FALSE,
  interval = FALSE, int.width = 0.95, outcome.scale = "response",
  add.re.variance = FALSE, linearity.check = FALSE, set.offset = 1,
  pred.labels = NULL, modx.labels = NULL, mod2.labels = NULL,
  int.type = c("confidence", "prediction"), preds.per.level = 100,
  boot = FALSE, sims = 100, progress = "txt", force.cat = FALSE,
  facet.modx = linearity.check, ...)
}
\arguments{
\item{model}{A \code{merMod} model.}

\item{pred}{The name of the predictor variable involved
in the interaction. This must be a string.}

\item{pred.values}{Which values of the predictor should be included in the
plot? By default, all levels are included.}

\item{modx}{The name of the moderator variable involved
in the interaction. This must be a string.}

\item{modx.values}{For which values of the moderator should lines be plotted?
Default is \code{NULL}. If \code{NULL}, then the customary +/- 1 standard
deviation from the mean as well as the mean itself are used for continuous
moderators. If \code{"plus-minus"}, plots lines when the moderator is at
+/- 1 standard deviation without the mean. You may also choose \code{"terciles"}
to split the data into equally-sized groups and choose the point at the
mean of each of those groups.

If the moderator is a factor variable and \code{modx.values} is
\code{NULL}, each level of the factor is included. You may specify
any subset of the factor levels (e.g., \code{c("Level 1", "Level 3")}) as long
as there is more than 1. The levels will be plotted in the order you
provide them, so this can be used to reorder levels as well.}

\item{mod2}{Optional. The name of the second moderator
variable involved in the interaction. This can be a bare name or string.}

\item{mod2.values}{For which values of the second moderator should the plot
be
facetted by? That is, there will be a separate plot for each level of this
moderator. Defaults are the same as \code{modx.values}.}

\item{centered}{A vector of quoted variable names that are to be
mean-centered. If \code{"all"}, all non-focal predictors are centered. You
may instead pass a character vector of variables to center. User can
also use "none" to base all predictions on variables set at 0.
The response variable, \code{pred}, \code{modx}, and \code{mod2} variables are never
centered.}

\item{data}{Optional, default is NULL. You may provide the data used to
fit the model. This can be a better way to get mean values for centering
and can be crucial for models with variable transformations in the formula
(e.g., \code{log(x)}) or polynomial terms (e.g., \code{poly(x, 2)}). You will
see a warning if the function detects problems that would likely be
solved by providing the data with this argument and the function will
attempt to retrieve the original data from the global environment.}

\item{plot.points}{Logical. If \code{TRUE}, plots the actual data points as
a scatterplot on top of the interaction lines. The color of the dots will
be based on their moderator value.}

\item{interval}{Logical. If \code{TRUE}, plots confidence/prediction
intervals around the line using \code{\link[ggplot2]{geom_ribbon}}.}

\item{int.width}{How large should the interval be, relative to the standard
error? The default, .95, corresponds to roughly 1.96 standard errors and
a .05 alpha level for values outside the range. In other words, for a
confidence interval, .95 is analogous to a 95\% confidence interval.}

\item{outcome.scale}{For nonlinear models (i.e., GLMs), should the outcome
variable be plotted on the link scale (e.g., log odds for logit models) or
the original scale (e.g., predicted probabilities for logit models)? The
default is \code{"response"}, which is the original scale. For the link
scale, which will show straight lines rather than curves, use
\code{"link"}.}

\item{add.re.variance}{Experimental. Adds variance specific to the
\emph{random} effects in the model. Often overwhelms the fixed effects
variances and makes the plot uninterpretable.}

\item{linearity.check}{For two-way interactions only. If \code{TRUE}, plots a
pane for each level of the moderator and superimposes a loess smoothed
line (in gray) over the plot. This enables you to see if the effect is
linear through the span of the moderator. See Hainmueller et al. (2016) in
the references for more details on the intuition behind this. It is
recommended that you also set \code{plot.points = TRUE} and use
\code{modx.values = "terciles"} with this option.}

\item{set.offset}{For models with an offset (e.g., Poisson models), sets an
offset for the predicted values. All predicted values will have the same
offset. By default, this is set to 1, which makes the predicted values a
proportion. See details for more about offset support.}

\item{pred.labels}{A character vector of 2 labels for the predictor if it is
a 2-level factor or a continuous variable with only 2 values. If
\code{NULL}, the default, the factor labels are used.}

\item{modx.labels}{A character vector of labels for each level of the
moderator values, provided in the same order as the \code{modx.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{modx,values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{mod2.labels}{A character vector of labels for each level of the 2nd
moderator values, provided in the same order as the \code{mod2.values}
argument. If \code{NULL}, the values themselves are used as labels unless
\code{mod2.values} is also \code{NULL}. In that case, "+1 SD" and "-1 SD"
are used.}

\item{int.type}{Type of interval to plot. Options are "confidence" or
"prediction". Default is confidence interval.}

\item{preds.per.level}{For continuous predictors, a series of equally
spaced points across the observed range of the predictor are used to
create the lines for each level of the moderator. Use this to choose
how many points are used for that. Default is 100, but for complicated
models larger numbers may better capture the curvature.}

\item{boot}{Use \code{\link[lme4:bootMer]{lme4::bootMer()}} to generate confidence intervals instead
of estimating fixed effects variance with variance-covariance matrices?
Default is FALSE but this is probably more defensible for
publication-level output. See Details for a little bit more information.}

\item{sims}{How many bootstrap simulations should be used? Default is 100,
but should usually be much higher. Just be aware that runtime may be
considerable.}

\item{progress}{Should a progress bar be shown during bootstrapping and if
so, how should it look?
Default is "txt", which is probably what you want to use, but "none" will
suppress the progress bar.}

\item{force.cat}{If \code{TRUE}, treats numeric predictor as categorical. This
can be helpful when you have 0/1 dummy variables that you don't want to
plot as if intermediate values are possible.}

\item{facet.modx}{Create separate panels for each level of the moderator?
Default is FALSE, except when \code{linearity.check} is TRUE.}

\item{...}{Extra arguments passed to \code{\link[lme4:bootMer]{lme4::bootMer()}} if \code{boot} is TRUE.}
}
\description{
This function produces predicted data for merMod models,
including confidence intervals calculated via one of two methods if
requested.
}
\details{
The ability to bootstrap the variances is not available through
\code{interact_plot}, \code{effect_plot}, and \code{cat_plot} to keep those functions
as simple as possible. Internally, \code{\link[lme4:bootMer]{lme4::bootMer()}} is called with
with default arguments (\code{type = "parametric"}, \code{use.u = FALSE}). To
get parallel processing, add the arguments \code{parallel = "multicore"} or
\code{parallel = "snow"} and \code{ncpus =} the number of cores.
}
