% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/scale_lm.R
\name{scale_mod}
\alias{scale_mod}
\alias{scale_mod.default}
\alias{scale_lm}
\title{Scale variables in fitted regression models}
\usage{
scale_mod(model, ...)

\method{scale_mod}{default}(model, binary.inputs = "0/1", n.sd = 1,
  center = TRUE, scale.response = FALSE, center.only = FALSE,
  data = NULL, vars = NULL,
  apply.weighted.contrasts = getOption("jtools-weighted.contrasts", FALSE),
  ...)
}
\arguments{
\item{model}{A regression model of type \code{lm}, \code{glm},
\code{\link[survey]{svyglm}}, or \link[lme4:merMod]{lme4::merMod}. Other model types
may work as well but are not tested.}

\item{...}{Ignored.}

\item{binary.inputs}{Options for binary variables. Default is \code{"0/1"};
\code{"0/1"} keeps original scale; \code{"-0.5,0.5"} rescales 0 as -0.5
and
1 as 0.5; \code{center} subtracts the mean; and \code{full} treats them
like other continuous variables.}

\item{n.sd}{How many standard deviations should you divide by for
standardization? Default is 1, though some prefer 2.}

\item{center}{Default is \code{TRUE}. If \code{TRUE}, the predictors are
also
mean-centered. For binary predictors, the \code{binary.inputs} argument
supersedes this one.}

\item{scale.response}{Should the response variable also be rescaled? Default
is \code{FALSE}.}

\item{center.only}{Rather than actually scale predictors, just mean-center
them.}

\item{data}{If you provide the data used to fit the model here, that data
frame is used to re-fit the model instead of the \code{\link[stats:model.frame]{stats::model.frame()}}
of the model. This is particularly useful if you have variable
transformations or polynomial terms specified in the formula.}

\item{vars}{A character vector of variable names that you want to be
scaled. If NULL, the default, it is all predictors.}

\item{apply.weighted.contrasts}{Factor variables cannot be scaled, but you
can set the contrasts such that the intercept in a regression model will
reflect the true mean (assuming all other variables are centered). If set
to TRUE, the argument will apply weighted effects coding to all factors.
This is similar to the R default effects coding, but weights according to
how many observations are at each level. An adapted version of
\code{\link[wec:contr.wec]{wec::contr.wec()}} from the \pkg{wec} package is used to do this. See
that package's documentation and/or Grotenhuis et al. (2016) for more
info.}
}
\value{
The functions returns a re-fitted model object, inheriting
from whichever class was supplied.
}
\description{
\code{scale_mod} (previously known as \code{scale_lm}) takes fitted regression models
and scales all
predictors by dividing each by 1 or 2 standard deviations (as chosen by the
user).
}
\details{
This function will scale all continuous variables in a regression
model for ease of interpretation, especially for those models that have
interaction terms. It can also mean-center all of them as well, if
requested.

The scaling happens on the input data, not the terms themselves. That
means interaction terms are still properly calculated because they are
the product of standardized predictors, not a standardized product of
predictors.

This function re-estimates the model, so for large models one should
expect a runtime equal to the first run.
}
\examples{

fit <- lm(formula = Murder ~ Income * Illiteracy,
          data = as.data.frame(state.x77))
fit_scale <- scale_mod(fit)
fit_scale <- scale_mod(fit, center = TRUE)

# With weights
fitw <- lm(formula = Murder ~ Income * Illiteracy,
           data = as.data.frame(state.x77),
           weights = Population)
fitw_scale <- scale_mod(fitw)
fitw_scale <- scale_mod(fitw, center = TRUE, binary.input = "0/1")

# With svyglm
if (requireNamespace("survey")) {
library(survey)
data(api)
dstrat<-svydesign(id=~1,strata=~stype, weights=~pw, data=apistrat, fpc=~fpc)
regmodel <- svyglm(api00~ell*meals,design=dstrat)
regmodel_scale <- scale_mod(regmodel)
regmodel_scale <- scale_mod(regmodel, binary.input = "0/1")
}

}
\references{
Bauer, D. J., & Curran, P. J. (2005). Probing interactions in fixed and
multilevel regression: Inferential and graphical techniques.
\emph{Multivariate Behavioral Research}, \emph{40}(3), 373-400.

Cohen, J., Cohen, P., West, S. G., & Aiken, L. S. (2003). \emph{Applied
multiple regression/correlation analyses for the behavioral sciences} (3rd
ed.). Mahwah, NJ: Lawrence Erlbaum Associates, Inc.
}
\seealso{
\code{\link{sim_slopes}} performs a simple slopes analysis.

\code{\link{interact_plot}} creates attractive, user-configurable plots of
interaction models.

Other standardization, scaling, and centering tools: \code{\link{center_mod}},
  \code{\link{center}}, \code{\link{gscale}},
  \code{\link{standardize}}
}
\author{
Jacob Long <\email{long.1377@osu.edu}>
}
