## ----echo=FALSE----------------------------------------------------------
knitr::opts_chunk$set(message=F, warning=F)
library(jtools)

## ------------------------------------------------------------------------
# Fit model
fit <- lm(Income ~ Frost + Illiteracy + Murder, data = as.data.frame(state.x77))
j_summ(fit)

## ------------------------------------------------------------------------
j_summ(fit, model.info = FALSE, model.fit = FALSE)

## ------------------------------------------------------------------------
j_summ(fit, model.check = TRUE)

## ------------------------------------------------------------------------
j_summ(fit, robust = TRUE, robust.type = "HC3")

## ------------------------------------------------------------------------
j_summ(fit, standardize = TRUE)

## ------------------------------------------------------------------------
j_summ(fit, standardize = TRUE, n.sd = 2)

## ------------------------------------------------------------------------
j_summ(fit, center = TRUE)

## ------------------------------------------------------------------------
j_summ(fit, confint = TRUE, digits = 2)

## ------------------------------------------------------------------------
j_summ(fit, confint = TRUE, ci.width = .5, digits = 2)

## ------------------------------------------------------------------------
j_summ(fit, confint = TRUE, pvals = FALSE, digits = 2)

## ------------------------------------------------------------------------
fitg <- glm(vs ~ drat + mpg, data = mtcars, family = binomial)

j_summ(fitg)

## ------------------------------------------------------------------------
j_summ(fitg, odds.ratio = TRUE)

## ----message = FALSE, warning = FALSE------------------------------------
library(lme4)
fm1 <- lmer(Reaction ~ Days + (Days | Subject), sleepstudy)

j_summ(fm1)

## ------------------------------------------------------------------------
j_summ(fit, model.info = FALSE, digits = 5)

## ------------------------------------------------------------------------
j_summ(fit, model.info = FALSE, digits = 1)

## ------------------------------------------------------------------------
options("jtools-digits" = 2)
j_summ(fit, model.info = FALSE)

## ----echo = F------------------------------------------------------------
options("jtools-digits" = NA)

## ------------------------------------------------------------------------
j <- j_summ(fit, digits = 3)

j$coeftable

## ------------------------------------------------------------------------
j_summ(fit, vifs = TRUE)

