% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_compile.R
\name{pot_list}
\alias{pot_list}
\alias{pot_list.data.frame}
\title{A check and extraction of clique potentials from a Markov random field
to be used in the junction tree algorithm}
\usage{
pot_list(x, g)

\method{pot_list}{data.frame}(x, g)
}
\arguments{
\item{x}{Character \code{data.frame}}

\item{g}{A decomposable Markov random field as an igraph object.}
}
\description{
A check and extraction of clique potentials from a Markov random field
to be used in the junction tree algorithm
}
\examples{

# Typically one would use the ess package:
# library(ess)
# g  <- ess::fit_graph(derma)
# pl <- pot_list(derma, ess::as_igraph(g))
# pl

# Another example
g <- igraph::sample_gnm(ncol(asia), 12)
while(!igraph::is.chordal(g)$chordal) g <- igraph::sample_gnm(ncol(asia), 12, FALSE)
igraph::V(g)$name <- colnames(asia)
plot(g)
pot_list(asia, g)

}
