/*
 * Decompiled with CFR 0.152.
 */
package org.fgilbert.jsr223;

import org.fgilbert.jdx.JavaToR;
import org.fgilbert.jsr223.CallbackEvaluation;
import org.fgilbert.jsr223.CallbackGetValue;
import org.fgilbert.jsr223.CallbackSetValue;
import org.fgilbert.jsr223.Controller;
import org.fgilbert.jsr223.EvaluationThread;
import org.fgilbert.jsr223.Message;

public class RClient {
    private Controller controller;
    private EvaluationThread evaluationThread;

    RClient(Controller controller, EvaluationThread evaluationThread) {
        this.controller = controller;
        this.evaluationThread = evaluationThread;
    }

    public Object eval(String script) throws Throwable {
        this.controller.putQueueItem(new JavaToR((Object)new CallbackEvaluation(script), 0x1000000));
        Message message = null;
        while (true) {
            if ((message = this.evaluationThread.getQueueItem()).getMessageType() == Message.MessageType.RESPONSE) {
                if (message.getSubject() != Message.Subject.RSP_ERROR) break;
                throw new RuntimeException((String)message.getData());
            }
            this.evaluationThread.processRequest(message);
        }
        return message.getData();
    }

    public Object get(String key) throws Throwable {
        this.controller.putQueueItem(new JavaToR((Object)new CallbackGetValue(key), 0x2000000));
        Message message = this.evaluationThread.getQueueItem();
        if (message.getSubject() == Message.Subject.RSP_ERROR) {
            throw new RuntimeException((String)message.getData());
        }
        return message.getData();
    }

    public void set(String key, Object value) throws Throwable {
        this.controller.putQueueItem(new JavaToR((Object)new CallbackSetValue(key, new JavaToR(value, this.controller.getArrayOrder())), 0x3000000));
        Message message = this.evaluationThread.getQueueItem();
        if (message.getSubject() == Message.Subject.RSP_ERROR) {
            throw new RuntimeException((String)message.getData());
        }
    }
}

