% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/json_gzip.R
\name{gzjson}
\alias{gzjson}
\alias{as_gzjson_raw}
\alias{as_gzjson_b64}
\alias{parse_gzjson_raw}
\alias{parse_gzjson_b64}
\title{Gzipped JSON}
\usage{
as_gzjson_raw(x, ...)

as_gzjson_b64(x, ...)

parse_gzjson_raw(buf, ...)

parse_gzjson_b64(b64, ...)
}
\arguments{
\item{x}{R data object to be converted to JSON}

\item{...}{passed down to \link{toJSON} or \link{fromJSON}}

\item{buf}{raw vector with gzip compressed data}

\item{b64}{base64 encoded string containing gzipped json data}
}
\description{
Wrapper to generate and parse gzipped JSON, in order to save some disk or
network space. This is mainly effective for larger json objects with many
repeated keys, as is common in serialized data frames.
}
\details{
The \link{as_gzjson_raw} and \link{parse_gzjson_raw} functions work with raw (binary)
vectors of compressed data. To use this in a place where only text is allowed
you can wrap the output again in \link{base64} as done by \link{as_gzjson_b64} and
\link{parse_gzjson_b64}. This increases the size again with about 33\%.
}
\examples{
str <- as_gzjson_b64(iris[1:5,])
cat(str)
parse_gzjson_b64(str)
}
