% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/freq_table.R
\name{freq_table}
\alias{freq_table}
\title{Tabulate simple frequencies}
\usage{
freq_table(x, byvar, digits = 1, na.rm = FALSE, freq_var_name = "n")
}
\arguments{
\item{x}{data frame}

\item{byvar}{character: name of variable to tabulate. Use Standard evaluation.}

\item{digits}{numeric: number of decimal places to display. Default is 1.}

\item{na.rm}{logical: report NA values in frequencies. Default is FALSE.}

\item{freq_var_name}{character: name for frequency variable. Default is "n"}
}
\value{
data.table with frequencies.
}
\description{
tabulate one variable frequencies
}
\examples{
library(data.table)
x4 = data.table(id1 = c(1, 1, 2, 3, 3),
                id2 = c(1, 1, 2, 3, 4),
                t   = c(1L, 2L, 1L, 2L, NA_integer_),
                x   = c(16, 12, NA, NA, 15))
freq_table(x4, "id1")
}
