% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/possible_ids.R
\name{create_ids}
\alias{create_ids}
\title{Create variables that uniquely identify rows in a data table}
\usage{
create_ids(n_rows, n_ids, prefix = "id")
}
\arguments{
\item{n_rows}{An integer specifying the number of rows in the data table for which unique identifiers need to be generated.}

\item{n_ids}{An integer specifying the number of identifiers to be created. If \code{n_ids} is 1, a simple sequence of unique IDs is created. If greater than 1, a combination of IDs is generated.}

\item{prefix}{A character string specifying the prefix for the identifier variable names (default is \code{"id"}).}
}
\value{
A named list where each element is a vector representing a unique identifier column. The number of elements in the list corresponds to the number of identifier variables (\code{n_ids}). The length of each element is equal to \code{n_rows}.
}
\description{
This function generates unique identifier columns for a given number of rows, based on the specified number of identifier variables.
}
\keyword{internal}
