% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/format_vectors.R
\name{fround_dtype_lancet}
\alias{fround_dtype_lancet}
\title{Format and round with data-type suffix}
\usage{
fround_dtype_lancet(
  x,
  d_type = "prop",
  digits = 1L,
  nsmall = 1L,
  decimal.mark = mid_dot()
)
}
\arguments{
\item{x}{[num] numeric value}

\item{d_type}{[chr c('prop', 'pp', or 'count')] data type - proportion, percentage point or count}

\item{digits}{[integer: default 1L] passed to `round()`}

\item{nsmall}{[integer: default 1L] passed to `format()`}

\item{decimal.mark}{[chr: default mid_dot()] decimal mark passed to `format()`}
}
\value{
[chr] formatted string
}
\description{
Lancet-specific wrapper for `fround_dtype()`, using mid-dot as decimal mark.
}
\examples{
fround_dtype_lancet(0.123456789)
fround_dtype_lancet(0.123456789, 'pp', 3, 4)
fround_dtype_lancet(c(55.8346, 123.456789), 'count', 3, 4, ".")
}
\seealso{
Other vector_formats: 
\code{\link{fmt_magnitude}()},
\code{\link{format_oxford_comma}()},
\code{\link{fround}()},
\code{\link{fround_count}()},
\code{\link{fround_dtype}()},
\code{\link{fround_props}()}
}
\concept{vector_formats}
