% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/general.R
\name{plot.post_jointVIP}
\alias{plot.post_jointVIP}
\title{plot the post_jointVIP object
this plot uses the same custom options as the jointVIP object}
\usage{
\method{plot}{post_jointVIP}(
  x,
  ...,
  smd = "OVB-based",
  use_abs = TRUE,
  plot_title = "Joint Variable Importance Plot",
  add_post_labs = TRUE,
  post_label_cut_bias = 0.005
)
}
\arguments{
\item{x}{a post_jointVIP object}

\item{...}{custom options: \code{bias_curve_cutoffs}, \code{text_size}, \code{max.overlaps}, \code{label_cut_std_md}, \code{label_cut_outcome_cor}, \code{label_cut_bias}, \code{OVB_curves}, \code{add_var_labs}, \code{expanded_y_curvelab}}

\item{smd}{specify the standardized mean difference is \code{OVB-based} or \code{standard}}

\item{use_abs}{TRUE (default) for absolute measures}

\item{plot_title}{optional string for plot title}

\item{add_post_labs}{TRUE (default) show post-measure labels}

\item{post_label_cut_bias}{0.005 (default) show cutoff above this number; suppressed if show_post_labs is FALSE}
}
\value{
a post-analysis joint variable importance plot of class \code{ggplot}
}
\description{
plot the post_jointVIP object
this plot uses the same custom options as the jointVIP object
}
\examples{
data <- data.frame(year = rnorm(50, 200, 5),
                   pop = rnorm(50, 1000, 500),
                   gdpPercap = runif(50, 100, 1000),
                   trt = rbinom(50, 1, 0.5),
                   out = rnorm(50, 1, 0.2))
# random 20 percent of control as pilot data                  
pilot_sample_num = sample(which(data$trt == 0),
                          length(which(data$trt == 0)) *
                          0.2)
pilot_df = data[pilot_sample_num, ]
analysis_df = data[-pilot_sample_num, ]
treatment = "trt"
outcome = "out"
covariates = names(analysis_df)[!names(analysis_df)
                                \%in\% c(treatment, outcome)]
new_jointVIP = create_jointVIP(treatment = treatment,
                               outcome = outcome,
                               covariates = covariates,
                               pilot_df = pilot_df,
                               analysis_df = analysis_df)
                               
## at this step typically you may wish to do matching or weighting
## the results after can be stored as a post_data
## the post_data here is not matched or weighted, only for illustrative purposes
post_data <- data.frame(year = rnorm(50, 200, 5),
                        pop = rnorm(50, 1000, 500),
                        gdpPercap = runif(50, 100, 1000),
                        trt = rbinom(50, 1, 0.5),
                        out = rnorm(50, 1, 0.2))
post_dat_jointVIP = create_post_jointVIP(new_jointVIP, post_data)
plot(post_dat_jointVIP)
}
