% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/logLik.mjoint.R
\name{logLik.mjoint}
\alias{logLik.mjoint}
\title{Extract log-likelihood from an \code{mjoint} object}
\usage{
\method{logLik}{mjoint}(object, ...)
}
\arguments{
\item{object}{an object inheriting from class \code{mjoint} for a joint model
of time-to-event and multivariate longitudinal data.}

\item{...}{additional arguments; currently none are used.}
}
\value{
Returns an object of class \code{logLik}. This is a number with two
  attributes: \code{df} (degrees of freedom), giving the number of parameters
  in the model, and \code{nobs}, the number of observations used in
  estimation.
}
\description{
Extract log-likelihood from an \code{mjoint} object.
}
\examples{
\dontrun{
# Fit a joint model with bivariate longitudinal outcomes

data(heart.valve)
hvd <- heart.valve[!is.na(heart.valve$log.grad) & !is.na(heart.valve$log.lvmi), ]
fit2 <- mjoint(
    formLongFixed = list("grad" = log.grad ~ time + sex + hs,
                         "lvmi" = log.lvmi ~ time + sex),
    formLongRandom = list("grad" = ~ 1 | num,
                          "lvmi" = ~ time | num),
    formSurv = Surv(fuyrs, status) ~ age,
    data = list(hvd, hvd),
    inits = list("gamma" = c(0.11, 1.51, 0.80)),
    timeVar = "time",
    verbose = TRUE)

logLik(fit2)
}
}
\references{
Henderson R, Diggle PJ, Dobson A. Joint modelling of longitudinal
measurements and event time data. \emph{Biostatistics.} 2000; \strong{1(4)}:
465-480.
}
\seealso{
\code{\link[stats]{logLik}} for the generic method description.
}
\author{
Graeme L. Hickey (\email{graeme.hickey@liverpool.ac.uk})
}
\keyword{methods}
