
# This file is automatically generated, you probably don't want to edit this

propTestNOptions <- if (requireNamespace('jmvcore')) R6::R6Class(
    "propTestNOptions",
    inherit = jmvcore::Options,
    public = list(
        initialize = function(
            var = NULL,
            counts = NULL,
            expected = FALSE,
            ratio = NULL, ...) {

            super$initialize(
                package='jmv',
                name='propTestN',
                requiresData=TRUE,
                ...)

            private$..var <- jmvcore::OptionVariable$new(
                "var",
                var,
                suggested=list(
                    "nominal",
                    "ordinal"),
                permitted=list(
                    "factor"))
            private$..counts <- jmvcore::OptionVariable$new(
                "counts",
                counts,
                default=NULL,
                permitted=list(
                    "numeric"))
            private$..expected <- jmvcore::OptionBool$new(
                "expected",
                expected,
                default=FALSE)
            private$..ratio <- jmvcore::OptionArray$new(
                "ratio",
                ratio,
                template=jmvcore::OptionNumber$new(
                    "ratio",
                    NULL,
                    min=0,
                    default=1),
                default=NULL)

            self$.addOption(private$..var)
            self$.addOption(private$..counts)
            self$.addOption(private$..expected)
            self$.addOption(private$..ratio)
        }),
    active = list(
        var = function() private$..var$value,
        counts = function() private$..counts$value,
        expected = function() private$..expected$value,
        ratio = function() private$..ratio$value),
    private = list(
        ..var = NA,
        ..counts = NA,
        ..expected = NA,
        ..ratio = NA)
)

propTestNResults <- if (requireNamespace('jmvcore')) R6::R6Class(
    inherit = jmvcore::Group,
    active = list(
        props = function() private$.items[["props"]],
        tests = function() private$.items[["tests"]]),
    private = list(),
    public=list(
        initialize=function(options) {
            super$initialize(
                options=options,
                name="",
                title="Proportion Test (N Outcomes)")
            self$add(jmvcore::Table$new(
                options=options,
                name="props",
                title="`Proportions - ${var}`",
                rows="(levels(var))",
                clearWith=list(
                    "var",
                    "ratio",
                    "counts"),
                columns=list(
                    list(
                        `name`="level", 
                        `title`="Level", 
                        `type`="text", 
                        `content`="($key)"),
                    list(
                        `name`="name[obs]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Observed", 
                        `visible`="(expected)"),
                    list(
                        `name`="count[obs]", 
                        `title`="Count", 
                        `type`="integer"),
                    list(
                        `name`="prop[obs]", 
                        `title`="Proportion", 
                        `type`="number"),
                    list(
                        `name`="name[exp]", 
                        `title`="", 
                        `type`="text", 
                        `content`="Expected", 
                        `visible`="(expected)"),
                    list(
                        `name`="count[exp]", 
                        `title`="Count", 
                        `type`="number", 
                        `visible`="(expected)"),
                    list(
                        `name`="prop[exp]", 
                        `title`="Proportion", 
                        `type`="number", 
                        `visible`="(expected)"))))
            self$add(jmvcore::Table$new(
                options=options,
                name="tests",
                title="\u03C7\u00B2 Goodness of Fit",
                rows=1,
                clearWith=list(
                    "var",
                    "ratio",
                    "counts"),
                columns=list(
                    list(
                        `name`="chi", 
                        `title`="\u03C7\u00B2", 
                        `type`="number"),
                    list(
                        `name`="df", 
                        `title`="df", 
                        `type`="integer"),
                    list(
                        `name`="p", 
                        `title`="p", 
                        `type`="number", 
                        `format`="zto,pvalue"))))}))

propTestNBase <- if (requireNamespace('jmvcore')) R6::R6Class(
    "propTestNBase",
    inherit = jmvcore::Analysis,
    public = list(
        initialize = function(options, data=NULL, datasetId="", analysisId="", revision=0) {
            super$initialize(
                package = 'jmv',
                name = 'propTestN',
                version = c(1,0,0),
                options = options,
                results = propTestNResults$new(options=options),
                data = data,
                datasetId = datasetId,
                analysisId = analysisId,
                revision = revision,
                pause = NULL,
                completeWhenFilled = TRUE,
                requiresMissings = FALSE)
        }))

#' Proportion Test (N Outcomes)
#'
#' The X² Goodness of fit test (not to be confused with the X² test of 
#' independence), tests the Null hypothesis that the proportions of 
#' observations match some expected proportions. If the p-value is low, this 
#' suggests that the Null hypothesis is false, and that the true proportions 
#' are different to those tested.
#' 
#'
#' @examples
#' data('HairEyeColor')
#' dat <- as.data.frame(HairEyeColor)
#'
#' propTestN(formula = Freq ~ Eye, data = dat, ratio = c(1,1,1,1))
#'
#' #
#' #  PROPORTION TEST (N OUTCOMES)
#' #
#' #  Proportions
#' #  --------------------------------
#' #    Level    Count    Proportion
#' #  --------------------------------
#' #    Brown      220         0.372
#' #    Blue       215         0.363
#' #    Hazel       93         0.157
#' #    Green       64         0.108
#' #  --------------------------------
#' #
#' #
#' #  X² Goodness of Fit
#' #  -----------------------
#' #    X²     df    p
#' #  -----------------------
#' #    133     3    < .001
#' #  -----------------------
#' #
#'
#' @param data the data as a data frame
#' @param var the variable of interest in \code{data} (not necessary when
#'   using a formula, see the examples)
#' @param counts the counts in \code{data}
#' @param expected \code{TRUE} or \code{FALSE} (default), whether expected
#'   counts should be displayed
#' @param ratio a vector of numbers: the expected proportions
#' @param formula (optional) the formula to use, see the examples
#' @return A results object containing:
#' \tabular{llllll}{
#'   \code{results$props} \tab \tab \tab \tab \tab a table of the proportions \cr
#'   \code{results$tests} \tab \tab \tab \tab \tab a table of the test results \cr
#' }
#'
#' Tables can be converted to data frames with \code{asDF} or \code{\link{as.data.frame}}. For example:
#'
#' \code{results$props$asDF}
#'
#' \code{as.data.frame(results$props)}
#'
#' @export
propTestN <- function(
    data,
    var,
    counts = NULL,
    expected = FALSE,
    ratio = NULL,
    formula) {

    if ( ! requireNamespace('jmvcore'))
        stop('propTestN requires jmvcore to be installed (restart may be required)')

    if ( ! missing(formula)) {
        if (missing(counts))
            counts <- jmvcore::marshalFormula(
                formula=formula,
                data=`if`( ! missing(data), data, NULL),
                from='lhs',
                subset='1')
        if (missing(var))
            var <- jmvcore::marshalFormula(
                formula=formula,
                data=`if`( ! missing(data), data, NULL),
                from='rhs',
                subset='1')
    }

    if ( ! missing(var)) var <- jmvcore::resolveQuo(jmvcore::enquo(var))
    if ( ! missing(counts)) counts <- jmvcore::resolveQuo(jmvcore::enquo(counts))
    if (missing(data))
        data <- jmvcore::marshalData(
            parent.frame(),
            `if`( ! missing(var), var, NULL),
            `if`( ! missing(counts), counts, NULL))

    for (v in var) if (v %in% names(data)) data[[v]] <- as.factor(data[[v]])

    options <- propTestNOptions$new(
        var = var,
        counts = counts,
        expected = expected,
        ratio = ratio)

    analysis <- propTestNClass$new(
        options = options,
        data = data)

    analysis$run()

    analysis$results
}
