% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/track.R
\name{read_rsmc_besttrack}
\alias{read_rsmc_besttrack}
\alias{track_combine}
\title{Read RSMC Tokyo-Typhoon Center's best track data}
\usage{
read_rsmc_besttrack(path)

track_combine(
  data,
  group_vars = c("international_number", "storm_name"),
  keep_vars = NULL,
  geometry = geometry
)
}
\arguments{
\item{path}{path to best track data (\code{.txt}). Give the path as a directory
in the user's computer or the URL.}

\item{data}{Import data using \link{read_rsmc_besttrack}}

\item{group_vars}{To combine track variables.}

\item{keep_vars}{Keep variables.}

\item{geometry}{geometry column name (default \code{geometry}).}
}
\value{
a \code{tbl} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#stable}{\figure{lifecycle-stable.svg}{options: alt='[Stable]'}}}{\strong{[Stable]}}

Tidy formatting best track data and combine each point to line.
}
\details{
\itemize{
\item \code{read_rsmc_besttrack()}: Read single best track data into \link[sf:sf]{sf}
contains observation record as point.
\item \code{track_combine()}: Combine track data to line by id
(such as international_number and storm_name).
}
}
\examples{
read_rsmc_besttrack(path = system.file("dummy/bst.txt", package = "jmastats"))

read_rsmc_besttrack(path = system.file("dummy/bst.txt", package = "jmastats")) |>
  track_combine()
}
\seealso{
\url{https://www.jma.go.jp/jma/jma-eng/jma-center/rsmc-hp-pub-eg/RSMC_HP.htm}
}
