% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/prediction.R
\name{predJMbayes}
\alias{predJMbayes}
\title{Prediction using \code{JMbayes2}}
\usage{
predJMbayes(model, ids, process = "longitudinal", newdata, ...)
}
\arguments{
\item{model}{fitted model object}

\item{ids}{value of id}

\item{process}{see \code{jm}}

\item{newdata}{dataset having covariate information for the ids mentioned above.}

\item{...}{other parameter options, see \code{predict.jm}}
}
\value{
list of predicted value for the given id
}
\description{
prediction of survival probability and longitudinal marker using \code{jmBayes2} for BIG data
}
\examples{

 \donttest{
##
library(survival)
library(nlme)
library(dplyr)
jmcs1<-jmbayesBig(dtlong=long2,
dtsurv = surv2 ,
longm=y~ x7+visit,
survm=Surv(time,status)~x1+visit,
rd= ~ visit|id,
timeVar='visit',
nchain=1,
samplesize=200,
id='id')
mod3<-jmcs1
ydt<-long2\%>\%filter(id\%in\%c(900))
names(ydt)
cdt<-surv2[,'id']\%>\%filter(id\%in\%c(900))
names(cdt)
newdata<-full_join(ydt,cdt,by='id')
P2<-predJMbayes(model<-mod3,ids<-c(900),newdata=newdata,process = 'event')
plot(P2$p1[[1]])

##

   }
}
