% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jmcsBig.R
\name{jmcsBig}
\alias{jmcsBig}
\title{Joint model for BIG data using FastJM}
\usage{
jmcsBig(dtlong, dtsurv, longm, survm, samplesize = 50, rd, id)
}
\arguments{
\item{dtlong}{longitudinal dataset, which contains id,visit time,longitudinal measurements along with various covariates}

\item{dtsurv}{survival dataset corresponding to the longitudinal dataset, with survival status and survival time}

\item{longm}{model for longitudinal response}

\item{survm}{survival model}

\item{samplesize}{sample size to divide the Big data}

\item{rd}{random effect part}

\item{id}{name of id column in longitudinal dataset}
}
\value{
returns a list containing various output which are useful for prediction.
}
\description{
function for joint model in BIG DATA using \code{FastJM}
}
\examples{
  \donttest{
##
library(survival)
library(dplyr)
fit2<-jmcsBig(dtlong=data.frame(long2),dtsurv = data.frame(surv2),
longm=y~ x7+visit,survm=Surv(time,status)~x1+visit,rd= ~ visit|id,samplesize=200,id='id')
print(fit2)
##
  }


}
\references{
Li, Shanpeng, et al. "Efficient Algorithms and Implementation of a Semiparametric Joint Model for Longitudinal and Competing Risk Data: With Applications to Massive Biobank Data." Computational and Mathematical Methods in Medicine 2022 (2022).
}
\seealso{
\link{jmbayesBig},\link{jmstanBig},\link{joinRMLBig}
}
\author{
Atanu Bhattacharjee, Bhrigu Kumar Rajbongshi and Gajendra Kumar Vishwakarma
}
