% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/model.R
\name{jlm}
\alias{jlm}
\alias{jlmer}
\title{Fit a (mixed-effects) regression model in Julia}
\usage{
jlm(formula, data, family = "gaussian", contrasts = jl_contrasts(data), ...)

jlmer(
  formula,
  data,
  family = NULL,
  contrasts = jl_contrasts(data),
  ...,
  fit = TRUE,
  optsum = list(),
  progress = interactive()
)
}
\arguments{
\item{formula}{A formula written in Julia syntax. Can be a string or a
language object.}

\item{data}{A data frame}

\item{family}{A distribution family}

\item{contrasts}{A Julia dictionary of contrasts
Inferred from \code{data} by default.}

\item{...}{Additional arguments to the \code{fit()} function called in Julia}

\item{fit}{Whether to fit the model. If \code{FALSE}, returns the unfit model object.}

\item{optsum}{A list of values to set for the optimizer. See \verb{$optsum} of unfit
model for possible options.}

\item{progress}{Whether to print model fitting progress. Defaults to \code{interactive()}}
}
\value{
A julia model object of class \code{jlme}
}
\description{
Fit a (mixed-effects) regression model in Julia
}
\examples{
\dontshow{if (check_julia_ok()) (if (getRversion() >= "3.4") withAutoprint else force)(\{ # examplesIf}
\donttest{
jlme_setup(restart = TRUE)

# Fixed effects models
lm(mpg ~ hp, mtcars)
jlm(mpg ~ hp, mtcars)

# Auto-handling of contrasts
x <- mtcars
x$cyl_helm <- factor(x$cyl)
contrasts(x$cyl_helm) <- contr.helmert(3)
colnames(contrasts(x$cyl_helm)) <- c("4vs6", "4&6vs8")
lm(mpg ~ cyl_helm, x)
jlm(mpg ~ cyl_helm, x)

# Mixed effects models
library(lme4)

glmer(r2 ~ Anger + Gender + (1 | id), VerbAgg, family = "binomial")
jlmer(r2 ~ Anger + Gender + (1 | id), VerbAgg, family = "binomial")

# Set optimizer options via `optsum`
jlmer(
  r2 ~ Anger + Gender + (1 | id), VerbAgg, family = "binomial",
  optsum = list(
    optimizer = jl(":LN_NELDERMEAD"),
    maxfeval = 10L
  )
)

stop_julia()
}
\dontshow{\}) # examplesIf}
}
