% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/modeling.R
\name{mse}
\alias{mse}
\title{Mean Squared Error (MSE)}
\usage{
mse(y, yhat)
}
\arguments{
\item{y}{A \code{vector} of the true \eqn{y} values}

\item{yhat}{A \code{vector} of predicted \eqn{\hat{y}}{y hat} values.}
}
\value{
The MSE in \code{numeric} form.
}
\description{
Calculates the mean square of the model by taking the mean of the
sum of squares between the truth, \eqn{y}, and the predicted, \eqn{\hat{y}}{y hat}
at each observation \eqn{i}.
}
\details{
The equation for MSE is:
\deqn{\frac{1}{n}\sum\limits_{i = 1}^n {{{\left( {{y_i} - {{\hat y}_i}} \right)}^2}}}{mean((y-yhat)^2)}
}
\examples{
# Set seed for reproducibility
set.seed(100)

# Generate data
n = 1e2

y = rnorm(n)
yhat = rnorm(n, 0.5)

# Compute
o = mse(y, yhat)
}
