% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jenga.R, R/main.R
\docType{package}
\name{jenga}
\alias{jenga}
\alias{jenga-package}
\title{jenga: automatic projections of time features using KNN}
\usage{
jenga(
  ts,
  seq_len = NULL,
  k = NULL,
  method = NULL,
  kernel = NULL,
  ci = 0.8,
  n_windows = 10,
  mode = NULL,
  n_sample = 30,
  search = "random",
  dates = NULL,
  error_scale = "naive",
  error_benchmark = "naive",
  seed = 42
)
}
\arguments{
\item{ts}{A data frame with time features on columns}

\item{seq_len}{Positive integer. Time-step number of the projected sequence}

\item{k}{Positive integer. Number of neighbors to consider when applying kernel average. Min number is 3. Default: NULL (automatic selection).}

\item{method}{Positive integer. Distance method for calculating neighbors. Possibile options are: "euclidean", "manhattan", "canberra1", "minimum", "maximum", "minkowski", "bhattacharyya", "kullback_leibler", "jensen_shannon". Default: NULL (automatic selection).}

\item{kernel}{String. Distribution used to calculate kernel densities. Possible options are: "norm", "cauchy", "logis", "unif", "t". Default: NULL (automatic selection).}

\item{ci}{Confidence interval. Default: 0.8}

\item{n_windows}{Positive integer. Number of validation tests to measure/sample error. Default: 10.}

\item{mode}{String. Sequencing method: deterministic ("segmented"), or non-deterministic ("sampled"). Default: NULL (automatic selection).}

\item{n_sample}{Positive integer. Number of samples for grid or random search. Default: 30.}

\item{search}{String. Two option available: "grid", "random". Default: "random".}

\item{dates}{Date. Vector with dates for time features.}

\item{error_scale}{String. Scale for the scaled error metrics. Two options: "naive" (average of naive one-step absolute error for the historical series) or "deviation" (standard error of the historical series). Default: "naive".}

\item{error_benchmark}{String. Benchmark for the relative error metrics. Two options: "naive" (sequential extension of last value) or "average" (mean value of true sequence). Default: "naive".}

\item{seed}{Positive integer. Random seed. Default: 42.}
}
\value{
This function returns a list including:
\itemize{
\item exploration: list of all not-null models, complete with predictions, test metrics, prediction stats and plot
\item history: a table with the sampled models, hyper-parameters, validation errors, weighted average rank
\item best_model: results for the best model in term of weighted average rank, including:
\itemize{
\item predictions: min, max, q25, q50, q75, quantiles at selected ci, mean, sd, mode, skewness, kurtosis, IQR to range, risk ratio, upside probability and divergence for each point fo predicted sequences
\item testing_errors: training and testing errors for one-step and sequence for each ts feature (me, mae, mse, rmsse, mpe, mape, rmae, rrmse, rame, mase, smse, sce, gmrae)
\item pred_scores: a measure of prediction interval fit for each point in predicted sequence (value range from 0, out of boundaries, to 1, close to the median)
}
\item time_log
}
}
\description{
Automatic projections of time features using KNN
}
\examples{
jenga(covid_in_europe[, c(2, 3)], n_sample = 1)
jenga(covid_in_europe[, c(4, 5)], n_sample = 1)


}
\seealso{
Useful links:
\itemize{
  \item \url{https://rpubs.com/giancarlo_vercellino/jenga}
}

}
\author{
Giancarlo Vercellino \email{giancarlo.vercellino@gmail.com}
}
