% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/adorn_ns.R
\name{adorn_ns}
\alias{adorn_ns}
\title{Add underlying Ns to a tabyl displaying percentages.}
\usage{
adorn_ns(dat, position = "rear", ns = attr(dat, "core"))
}
\arguments{
\item{dat}{a data.frame of class \code{tabyl} that has had \code{adorn_percentages} and/or \code{adorn_pct_formatting} called on it.  If given a list of data.frames, this function will apply itself to each data.frame in the list (designed for 3-way \code{tabyl} lists).}

\item{position}{should the N go in the front, or in the rear, of the percentage?}

\item{ns}{the Ns to append.  The default is the "core" attribute of the input tabyl \code{dat}, where the original Ns of a two-way \code{tabyl} are stored.  However, if you need to modify the numbers, e.g., to format \code{4000} as \code{4,000} or \code{4k}, you can do that separately and supply the formatted result here.}
}
\value{
a data.frame with Ns appended
}
\description{
This function adds back the underlying Ns to a \code{tabyl} whose percentages were calculated using \code{adorn_percentages()}, to display the Ns and percentages together.  You can also call it on a non-tabyl data.frame with tabyl-like format to which you wish to append Ns.
}
\examples{

mtcars \%>\%
  tabyl(am, cyl) \%>\%
  adorn_percentages("col") \%>\%
  adorn_pct_formatting() \%>\%
  adorn_ns(position = "front")
}
