% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-plots.r
\name{shadowText}
\alias{shadowText}
\title{Draw text with shadow border}
\usage{
shadowText(
  x,
  y = NULL,
  labels = NULL,
  col = "white",
  bg = setTextContrastColor(col),
  r = getOption("jam.shadow.r", 0.15),
  offset = c(0.15, -0.15),
  n = getOption("jam.shadow.n", 8),
  outline = getOption("jam.outline", TRUE),
  alphaOutline = getOption("jam.alphaOutline", 0.4),
  shadow = getOption("jam.shadow", FALSE),
  shadowColor = getOption("jam.shadowColor", "black"),
  alphaShadow = getOption("jam.alphaShadow", 0.2),
  shadowOrder = c("each", "all"),
  cex = graphics::par("cex"),
  font = graphics::par("font"),
  doTest = FALSE,
  ...
)
}
\arguments{
\item{x, y}{numeric coordinates, either as vectors x and y, or x as a
two-color matrix recognized by \code{grDevices::xy.coords()}.}

\item{labels}{vector of labels to display at the corresponding xy
coordinates.}

\item{col, bg, shadowColor}{the label color, and background (outline) color,
and shadow color (if \code{shadow=TRUE}), for each
element in \code{labels}. Colors are applied in order, and recycled to
\code{length(labels)} as needed. By default \code{bg} will choose
a contrasting color, based upon \code{setTextContrastColor()}.
Also by default, the shadow is "black" true to its name, since it is
expected to darken the area around it.}

\item{r}{the outline radius, expressed as a fraction of the width of the
character "A" as returned by \code{graphics::strwidth()}.}

\item{offset}{the outline offset position in xy coordinates, expressed
as a fraction of the width of the character "A" as returned by
\code{graphics::strwidth()}, and \code{graphics::strheight()},
respectively.
The offset is only applied when \code{shadow=TRUE} to enable the shadow
effect.}

\item{n}{\code{numeric} steps around the label used to create the outline.
A higher number may be useful for very large font sizes, otherwise 8
is a reasonably good balance between detail and the number of labels
added.}

\item{outline}{\code{logical} whether to enable outline drawing.}

\item{alphaOutline, alphaShadow}{\code{numeric} alpha transparency to use
for the outline and shadow colors, respectively.}

\item{shadow}{\code{logical} whether to enable shadow drawing.}

\item{shadowOrder}{\code{character} value indicating when shadows are drawn
relative to drawing labels: \code{"each"} draws each shadow with each label,
so that shadows will overlap previous labels; \code{"all"} draws all shadows
first then all labels, so labels will always appear above all
shadows. See examples.}

\item{cex}{\code{numeric} scalar applied to font size, default \code{graphics::par("cex")}.}

\item{font}{\code{character} applied to font family, default \code{graphics::par("font")}.}

\item{doTest}{\code{logical} whether to create a visual example of output. Note
that it calls \code{\link{usrBox}} to color the plot area, and the
background can be overridden with something like \code{fill="navy"}.}

\item{...}{other parameters are passed to \code{\link[graphics]{text}}.
Note that certain parameters are not vectorized in that function,
such as \code{srt} which requires only a fixed value. To rotate each
label independently, multiple calls to \code{\link[graphics]{text}} or
\code{\link{shadowText}} must be made. Other parameters like \code{adj}
only accept up to two values, and those two values affect all label
positioning.}
}
\value{
invisible \code{list} of components used to call \code{graphics::text()},
including: x, y, allColors, allLabels, cex, font.
}
\description{
Draw text with shadow border
}
\details{
Draws text with the same syntax as \code{graphics::text()} except that
this function adds a contrasting color border around the text, which
helps visibility when the background color is either not known, or is
not expected to be a fixed contrasting color.

The function draws the label n times with the chosed background
color, then the label itself atop the background text. It does not
typically have a noticeable effect on rendering time, but it may
impact downstream uses in vector file formats like 'SVG' and 'PDF', where
text is stored as proper text and font objects. Take care when editing
text that the underlying shadow text is also edited in sync.

The parameter \code{doTest=TRUE} will display a visual example. The
background color can be modified with \code{fill="navy"} for example.
}
\examples{
shadowText(doTest=TRUE);
shadowText(doTest=TRUE, fill="navy");
shadowText(doTest=TRUE, fill="red4");

# example showing labels with overlapping shadows
withr::with_par(list("mfrow"=c(1, 2)), {
nullPlot(doBoxes=FALSE);
graphics::title(main="shadowOrder='each'");
shadowText(x=c(1.5, 1.65), y=c(1.5, 1.55),
   labels=c("one", "two"), cex=c(2, 4), shadowOrder="each")
nullPlot(doBoxes=FALSE);
graphics::title(main="shadowOrder='all'");
shadowText(x=c(1.5, 1.65), y=c(1.5, 1.55),
   labels=c("one", "two"), cex=c(2, 4), shadowOrder="all")
})

}
\seealso{
Other jam plot functions: 
\code{\link{adjustAxisLabelMargins}()},
\code{\link{coordPresets}()},
\code{\link{decideMfrow}()},
\code{\link{drawLabels}()},
\code{\link{getPlotAspect}()},
\code{\link{groupedAxis}()},
\code{\link{imageByColors}()},
\code{\link{imageDefault}()},
\code{\link{minorLogTicksAxis}()},
\code{\link{nullPlot}()},
\code{\link{plotPolygonDensity}()},
\code{\link{plotRidges}()},
\code{\link{plotSmoothScatter}()},
\code{\link{shadowText_options}()},
\code{\link{showColors}()},
\code{\link{sqrtAxis}()},
\code{\link{usrBox}()}
}
\concept{jam plot functions}
