% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/jamba-load-cache.R
\name{reload_rmarkdown_cache}
\alias{reload_rmarkdown_cache}
\title{Reload 'Rmarkdown' cache}
\usage{
reload_rmarkdown_cache(
  dir = ".",
  maxnum = 1000,
  max_cache_name = NULL,
  envir = new.env(),
  file_sort = c("globals", "objects", "ctime", "mtime"),
  preferred_load_types = c("lazyLoad", "load"),
  dryrun = FALSE,
  verbose = TRUE,
  ...
)
}
\arguments{
\item{dir}{\code{character} path to the directory that contains 'Rmarkdown'
cache files. Each file is recognized by the file extension \code{".rdx"}.}

\item{maxnum}{\code{integer} indicating the maximum number of cache files
to re-load, in order.}

\item{max_cache_name}{\code{character} optional string indicating the
name of an 'Rmarkdown' cache chunk where this function will stop
loading cache data. All cache files after this point will
not be loaded. This option is intended to help recreate the
data available to a particular 'Rmarkdown' chunk during
processing.}

\item{envir}{\code{environment} in which data is populated, default \code{new.env()}
creates a new \code{environment} which is returned invisibly.}

\item{file_sort}{\code{character} string indicating how to sort cache files,
default uses best available, in order: "globals" (global index file),
"objects" (object index file), "ctime" (creation time),
"mtime" (modification time). The global index is preferred, and
other options are intended for rare scenarios when the global
index is not available. The methods using \code{"mtime"} or \code{"ctime"}
\strong{is less accurate}, yet may be sufficient for simple output.
\itemize{
\item \code{"globals"} uses the \code{"__globals"} file in the cache directory.
\item \code{"objects"} uses the \code{"__objects"} file in the cache directory.
\item \code{ctime} sorts by file creation time
\item \code{mtime} sorts by file modification time
}}

\item{preferred_load_types}{\code{character} string indicating the preferred
load mechanism, default uses \code{"lazyLoad"} if '.rdx'/'.rdb' files
are available, otherwise \code{"load"} to load '.RData'/'.rda' files.
The 'lazyLoad' '.rdx'/.'rdb' files are created when 'Rmarkdown'
options include \verb{cache=TRUE, cache.lazy=TRUE}. The load option
is used when \verb{cache=TRUE, cache.lazy=FALSE} which is preferred
for some analyses involving large data objects.}

\item{dryrun}{\code{logical} default FALSE, whether to perform a dry-run,
which prints messages and does not load the data.}

\item{verbose}{\code{logical} default TRUE, whether to print verbose output.
This argument is not passed to other functions.}

\item{...}{additional arguments are passed to \code{lazyLoad()} or \code{load()}
as relevant to the method used to re-load the cache object data.}
}
\value{
\code{envir} is returned invisibly, with data objects populated
into that \code{environment}.
}
\description{
Reload 'Rmarkdown' cache in the order files were created, into an
R environment
}
\details{
This function is intended to help re-load 'Rmarkdown' cache files
created during the processing/rendering of an 'Rmarkdown' file.

By default, all cached R objects are loaded into the
environment defined by \code{envir}, However,
\strong{it is recommended that \code{envir} is used to define a new environment}
into which the cached session is loaded.

\if{html}{\out{<div class="sourceCode">}}\preformatted{cache_env <- new.env()
reload_rmarkdown_cache(cachedir, envir=cache_env)
}\if{html}{\out{</div>}}

From then on, the cached data objects can be seen with \code{ls(cache_env)}
and retrieved with \code{get("objectname", envir=cache_env)}.

If supplied with \code{maxnum} or \code{max_cache_name} then the cache
will be loaded only up to this point, and not beyond.
The recommended method to determine the cache is to use \code{dryrun=TRUE}
to view all sections, then to choose the \code{integer} number, or
\code{character} name to define the maximum chunk to load.
}
\seealso{
Other jam practical functions: 
\code{\link{breakDensity}()},
\code{\link{call_fn_ellipsis}()},
\code{\link{checkLightMode}()},
\code{\link{check_pkg_installed}()},
\code{\link{colNum2excelName}()},
\code{\link{color_dither}()},
\code{\link{exp2signed}()},
\code{\link{getAxisLabel}()},
\code{\link{isFALSEV}()},
\code{\link{isTRUEV}()},
\code{\link{jargs}()},
\code{\link{kable_coloring}()},
\code{\link{lldf}()},
\code{\link{log2signed}()},
\code{\link{middle}()},
\code{\link{minorLogTicks}()},
\code{\link{newestFile}()},
\code{\link{printDebug}()},
\code{\link{renameColumn}()},
\code{\link{rmInfinite}()},
\code{\link{rmNA}()},
\code{\link{rmNAs}()},
\code{\link{rmNULL}()},
\code{\link{setPrompt}()}
}
\concept{jam practical functions}
