% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/haps_functions.R
\name{haps_vcf}
\alias{haps_vcf}
\title{Organize information to create haplotypes using a VCF file}
\usage{
haps_vcf(fn, print_names = FALSE)
}
\arguments{
\item{fn}{A single string specifying the name of the VCF file}

\item{print_names}{Logical for whether to print all unique chromosome names from
the VCF file when VCF chromosome names don't match those from the reference genome.
This printing doesn't happen until this object is passed to \code{create_haplotypes}.
This can be useful for troubleshooting.
Defaults to \code{FALSE}.}
}
\value{
A \code{haps_vcf_info} object containing information used in \code{create_haplotypes}
to create variant haplotypes.
This class is just a wrapper around a list containing the arguments to this
function, which you can view (but not change) using the object's \code{fn()} and
\code{print_names()} methods.
}
\description{
This function organizes higher-level information for creating haplotypes from
Variant Call Format (VCF) files.
}
