% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/vars_functions.R
\name{vars_vcf}
\alias{vars_vcf}
\title{Create necessary information to create variants using a VCF file}
\usage{
vars_vcf(fn, print_names = FALSE, ...)
}
\arguments{
\item{fn}{A single string specifying the name of the VCF file}

\item{print_names}{Logical for whether to print all unique sequence names from
the VCF file when VCF sequence names don't match those from the reference genome.
This printing doesn't happen until this object is passed to \code{create_variants}.
This can be useful for troubleshooting.
Defaults to \code{FALSE}.}

\item{...}{Arguments to pass to \code{vcfR::read.vcfR}, excluding the \code{file} argument
that will be overridden with the \code{fn} argument to this function.}
}
\value{
A \code{vars_vcf_info} object containing information used in \code{create_variants}
to create haploid variants.
This class is just a wrapper around a list containing relevant output from
\code{vcfR::read.vcfR}:
haplotypes, reference sequences, positions, sequence names, and variant names.
}
\description{
This function organizes higher-level information for creating variants from
Variant Call Format (VCF) files.
}
\details{
This function won't work if the package \code{vcfR} isn't installed.
}
