% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ZonalQPol.R
\name{ZonalQPolR}
\alias{ZonalQPolR}
\title{Quaternionic zonal polynomial}
\usage{
ZonalQPolR(n, lambda, algorithm = "DK", basis = "canonical", exact = TRUE)
}
\arguments{
\item{n}{number of variables, a positive integer}

\item{lambda}{an integer partition, given as a vector of decreasing
integers}

\item{algorithm}{the algorithm used, either \code{"DK"} or \code{"naive"}}

\item{basis}{the polynomial basis for \code{algorithm = "naive"},
either \code{"canonical"} or \code{"MSF"} (monomial symmetric functions);
for \code{algorithm = "DK"} the canonical basis is always used and
this parameter is ignored}

\item{exact}{logical, whether to get rational coefficients}
}
\value{
A \code{mvp} multivariate polynomial (see \link[mvp]{mvp-package}),
 or a \code{qspray} multivariate polynomial if
 \code{exact = TRUE} and \code{algorithm = "DK"}, or a
 character string if \code{basis = "MSF"}.
}
\description{
Returns the quaternionic (or symplectic) zonal polynomial.
}
\examples{
ZonalQPolR(3, lambda = c(3,1), algorithm = "naive")
ZonalQPolR(3, lambda = c(3,1), algorithm = "DK")
ZonalQPolR(3, lambda = c(3,1), algorithm = "DK", exact = FALSE)
ZonalQPolR(3, lambda = c(3,1), algorithm = "naive", basis = "MSF")
}
