% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/plot.R
\name{rug_model}
\alias{rug_model}
\title{Add rug to plot, based on model.}
\usage{
rug_model(model, view, cond = NULL, data.rows = NULL, rm.ranef = NULL,
  print.summary = getOption("itsadug_print"), ...)
}
\arguments{
\item{model}{gam or bam object.}

\item{view}{Text string containing the name of the smooth
to be displayed. Note that 
variables coerced to factors in the model formula won't work as view 
variables.}

\item{cond}{A named list of the values to use for the other predictor terms 
(not in view). Used for choosing between smooths that share the same view 
predictors.}

\item{data.rows}{Vector of numbers (indices of rows in data) or vector of 
logical vales (same length as rows in data) for selecting specific data 
points.}

\item{rm.ranef}{Logical: whether or not to remove random effects. 
Default is TRUE.}

\item{print.summary}{Logical: whether or not to print information messages.
Default set to the print info messages option 
(see \code{\link{infoMessages}}).}

\item{...}{Optional graphical parameters (see \code{\link[graphics]{rug}}).}
}
\description{
Add rug based on model data.
}
\examples{
plot(cars$speed, cars$dist, pch=16, col=alpha(1))
lm1 <- lm(dist ~ speed, dat=cars)
abline(lm1, col='red', lwd=2)
rug_model(lm1, view="speed")
rug_model(lm1, view="dist", side=2)

\dontrun{
library(itsadug)
data(simdat)
m1 <- bam(Y ~ Group + te(Time, Trial, by=Group), data=simdat)
# plot:
fvisgam(m1, view=c("Time", "Trial"), cond=list(Group="Adults"))
rug_model(m1, view="Time", cond=list(Group="Adults"))
rug_model(m1, view="Trial", cond=list(Group="Adults"), side=2)
}
}
\seealso{
Other Functions for plotting: \code{\link{fadeRug}}
}
\author{
Jacolien van Rij
}
