% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/acf.R
\name{acf_plot}
\alias{acf_plot}
\title{Generate an ACF plot of an aggregated time series.}
\usage{
acf_plot(x, split_by = NULL, max_lag = NULL, plot = TRUE, fun = mean,
  cond = NULL, return_all = FALSE, ...)
}
\arguments{
\item{x}{A vector with time series data, typically residuals of a 
regression model. 
(See examples for how to avoid errors due to missing values.)}

\item{split_by}{List of vectors (each with equal length as \code{x}) that 
group the values of \code{x} into trials or timeseries events. 
Generally other columns from the same data frame.}

\item{max_lag}{Maximum lag at which to calculate the acf. 
Default is the maximum for the longest time series.}

\item{plot}{Logical: whether or not to plot the ACF. Default is TRUE.}

\item{fun}{The function used when aggregating over time series 
(depending on the value of \code{split_by}).}

\item{cond}{Named list with a selection of the time series events
specified in \code{split_by}. Default is NULL, indicating that 
all time series are being processed, rather than a selection.}

\item{return_all}{Returning acfs for all time series.}

\item{...}{Other arguments for plotting, see \code{\link[graphics]{par}}.}
}
\value{
An aggregated ACF plot and / or optionally a list with the aggregated ACF values.
}
\description{
Generate an ACF plot of an aggregated time series.
}
\examples{
data(simdat)

# Default acf function:
acf(simdat$Y)
# Same plot with acf_plot:
acf_plot(simdat$Y)
# Average of ACFs per time series:
acf_plot(simdat$Y, split_by=list(simdat$Subject, simdat$Trial))
# Median of ACFs per time series:
acf_plot(simdat$Y, split_by=list(simdat$Subject, simdat$Trial), fun=median)

# extract value of Lag1:
lag1 <- acf_plot(simdat$Y, 
   split_by=list(Subject=simdat$Subject, Trial=simdat$Trial), 
   plot=FALSE)['1']

#---------------------------------------------
# When using model residuals
#---------------------------------------------

# add missing values to simdat:
simdat[sample(nrow(simdat), 15),]$Y <- NA
# simple linear model:
m1 <- lm(Y ~ Time, data=simdat)

\dontrun{
# This will generate an error:
acf_plot(resid(m1), split_by=list(simdat$Subject, simdat$Trial))
}
# This should work:
el.na <- missing_est(m1)
acf_plot(resid(m1), 
     split_by=list(simdat[-el.na,]$Subject, simdat[-el.na,]$Trial))

# This should also work:
simdat$res <- NA
simdat[!is.na(simdat$Y),]$res <- resid(m1)
acf_plot(simdat$res, split_by=list(simdat$Subject, simdat$Trial))

# see the vignette for examples:
vignette("acf", package="itsadug")

}
\seealso{
Use \code{\link[stats]{acf}} for the original ACF function, 
and \code{\link{acf_n_plots}} for inspection of individual time series.

Other functions for model criticism: \code{\link{acf_n_plots}},
  \code{\link{acf_resid}}, \code{\link{derive_timeseries}},
  \code{\link{resid_gam}}, \code{\link{start_event}},
  \code{\link{start_value_rho}}
}
\author{
Jacolien van Rij
}
