% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/itrax_ordination.r
\name{itrax_ordination}
\alias{itrax_ordination}
\title{Principle Component Analysis on Itrax scan data}
\usage{
itrax_ordination(
  dataframe,
  elementsonly = TRUE,
  zeros = "addone",
  transform = TRUE,
  return = "list",
  plot = FALSE
)
}
\arguments{
\item{dataframe}{pass the name of a dataframe parsed using \code{"itrax_import()"} or \code{"itrax_join()"}}

\item{elementsonly}{if TRUE, only chemical elements are included. If FALSE, the data is passed unfiltered, otherwise a character vector of desired variable names can be supplied}

\item{zeros}{if "addone", adds one to all values. If "limit", replaces zero values with 0.001. Otherwise a function can be supplied to remove zero values.}

\item{transform}{binary operator that if TRUE will center-log-transform the data, if FALSE will leave the data untransformed. Otherwise, a function can be supplied to transform the data.}

\item{return}{if "pca" the output of \code{prcomp()} is returned, otherwise "list" is a list including the transformed data, sample scores, and the output of prcomp().}

\item{plot}{set to true if a biplot is required as a side-effect}
}
\value{
either an output of \code{prcomp()}, or a list including the input data
}
\description{
Performs and visualises principle component analysis data from Itrax result data
}
\examples{
itrax_ordination(CD166_19_S1$xrf, plot = TRUE)

}
