% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ui_model-building.R
\name{set_split}
\alias{set_split}
\title{Flag some network compartments as being split compartments}
\usage{
set_split(nm, comps = NULL, which = NULL)
}
\arguments{
\item{nm}{A \code{networkModel} object.}

\item{comps}{Vector of strings, the names of the compartments to set split.}

\item{which}{Vector of integers giving the nm rows to update. Default is to
update all rows.}
}
\value{
A \code{networkModel} object.
}
\description{
Flag some network compartments as being split compartments
}
\examples{
library(magrittr)
x <- new_networkModel() \%>\%
   set_topo("NH4 -> algae -> daphnia") \%>\%
   set_split("algae")
topo(x)

}
