% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/run_composite_model.R
\name{compose_isobxr}
\alias{compose_isobxr}
\title{Compose a stable isotope box model scenario}
\usage{
compose_isobxr(
  workdir,
  SERIES_ID,
  time_units,
  COMPO_MASTER,
  plot_HIDE_BOXES_delta = NULL,
  plot_HIDE_BOXES_size = NULL,
  EACH_RUN_DIGEST = FALSE,
  to_CPS_DIGEST_CSVs = FALSE,
  plot_results = TRUE,
  save_run_outputs = FALSE
)
}
\arguments{
\item{workdir}{Working directory of \strong{\emph{0_ISOBXR_MASTER.xlsx}} master file, \cr
of the composite master file (e.g., \strong{\emph{0_COMPO_MASTER.xlsx}}) \cr
and where output files will be stored if exported by user. \cr
(character string)}

\item{SERIES_ID}{Name of the composite model series the run belongs to. \cr
It determines the folder in which the output files will be stored for this composite run.\cr
A composite run number is automatically linked to it,
subsequent runs can not overwrite a previous composite run.\cr
(character string)}

\item{time_units}{Vector defining the initial time unit
(identical to unit used in fluxes), \cr
followed by the time unit used for the graphical output.\cr
Character string, to be selected  among the following:\cr
\emph{micros, ms, s, min, h, d, wk, mo, yr, kyr, Myr, Gyr}\cr
e.g.,  c("d", "yr") to convert days into years}

\item{COMPO_MASTER}{Name of the composite master file (e.g., \strong{\emph{0_COMPO_MASTER.xlsx}}),
defining the composite run scenario. \cr
(character string)}

\item{plot_HIDE_BOXES_delta}{\emph{OPTIONAL} \cr
Vector of character strings, \cr
defining the names of the boxes to hide in the plot of the delta values as a function of time, edited as a pdf.
\cr (e.g., c("BOX_A", "BOX_C"))
\cr Default is NULL (no box hidden).}

\item{plot_HIDE_BOXES_size}{\emph{OPTIONAL} \cr
Vector of character strings, \cr
defining the names of the boxes to hide in the plot of the box sizes (masses of X) as a function of time, edited as a pdf.
\cr (e.g., c("BOX_A", "BOX_C"))
\cr Default is NULL (no box hidden).}

\item{EACH_RUN_DIGEST}{\emph{OPTIONAL} \cr
Logical value. \cr
Edits full digests for each model run
(all optional outputs of \code{\link{run_isobxr}} function) if TRUE. \cr
Default is FALSE.}

\item{to_CPS_DIGEST_CSVs}{\emph{OPTIONAL} \cr
Logical value. \cr
Exports all global csv outputs to \strong{\emph{0_CPS_DIGEST}} folder (full evD and full evS) if TRUE. \cr
Default is FALSE.}

\item{plot_results}{\emph{OPTIONAL} \cr
Logical value. \cr
If TRUE, plots in R session the composite model run evolution of delta values and box sizes
for boxes of interest
(see plot_HIDE_BOXES_delta and plot_HIDE_BOXES_size parameters to remove boxes from plots). \cr
Default is TRUE.}

\item{save_run_outputs}{\emph{OPTIONAL} \cr
Logical value. \cr
Allows saving all run outputs to working directory (workdir). \cr
By default, run outputs are stored in the temporary directory and are erased if not exported. \cr
Default is FALSE.}
}
\value{
Calculates the time evolution of delta values and box sizes in all boxes throughout scenario.

\code{\link{compose_isobxr}} returns by default a plot showing time evolution of delta values and box sizes
for all boxes \cr
(set plot_deltas = FALSE to mute the plots) \cr

The graphical results of the composite run can be also interactively explored using the
\code{\link{shinobxr_app}} function in case user saves the outputs to the working
directory (save_run_outputs = TRUE).

\code{\link{compose_isobxr}} creates a series of isotope data and metadata,
all of which are stored in a temporary directory. \cr
The user can save all outputs described below to their working directory
by setting save_run_outputs = TRUE (default is FALSE). \cr

\code{\link{compose_isobxr}} creates and stores all outputs in a dedicated dynamic steady SERIES directory
with the following name structure: \cr
\strong{\emph{3_CPS + SERIES_ID + YYY}}, where YYY is a composite scenario number automatically set between 001 and 999. \cr
No overwriting of previous composite runs is possible.

\code{\link{compose_isobxr}} base workflow:
\enumerate{
\item Creates the set of inputs and outputs for all successive \emph{n} runs,\cr
numbered from to 1 to \emph{n} in an XXXX format with the following format: \cr
\strong{\emph{CPS + SERIES_ID + YYY + XXXX + IN.Rda}} \cr
\strong{\emph{CPS + SERIES_ID + YYY + XXXX + OUT.Rda}} \cr
(see \code{\link{run_isobxr}} documentation)

\item Writes summarized results in the  \strong{\emph{0_CPS_DIGEST}} folder:
\enumerate{
\item LOG file of local composite run. \cr
(file name structure:  \strong{\emph{CPS + SERIES_ID + YYY + _LOG.csv}})
\item Composite master file. \cr
(file name structure:  \strong{\emph{CPS + SERIES_ID + YYY + _MASTER.xlsx}})
\item Dataset of temporal evolution of delta values (evD) in all boxes over the \emph{n} runs that constitute the composite run scenario \cr
(file name structure: \strong{\emph{CPS + SERIES_ID + YYY + evD.RDS}})
\item Dataset of temporal evolution of box sizes (evS, masses of X) in all boxes over the \emph{n} runs that constitute the composite run scenario \cr
(file name structure: \strong{\emph{CPS + SERIES_ID + YYY + evS.RDS}})
\item All-in-one plot of the evolution of delta values + sizes in all non hidden boxes. \cr
(file name structure: \strong{\emph{CPS + SERIES_ID + YYY + p_evDS.pdf}})
\item Multiple plots of the evolution of delta values in all non hidden boxes. \cr
(file name structure: \strong{\emph{CPS + SERIES_ID + YYY + pf_evD.pdf}})
\item Multiple plots of the evolution of box sizes in all non hidden boxes. \cr
(file name structure: \strong{\emph{CPS + SERIES_ID + YYY + pf_evS.pdf}})
}
}
}
\description{
A function to compose an isobxr box model scenario,
defined by a series of \emph{n} successive runs, \cr
each run inheriting from the final state conditions of the previous run. \cr
It is possible to force parameters at each run, namely:
\enumerate{
\item \strong{fluxes} \cr
(overwriting all or a subset of fluxes defined in \emph{0_ISOBXR_MASTER.xlsx} master file)
\item \strong{isotope fractionation coefficients} \cr
(overwriting all or a subset of coefficients defined in \emph{0_ISOBXR_MASTER.xlsx} master file)
\item \strong{box sizes} \cr
(overwriting all or a subset of box sizes defined in \emph{0_ISOBXR_MASTER.xlsx} master file)
\item \strong{rayleigh isotope distillation}
\item \strong{isotope composition of a source box at initial state}
}
}
\section{Optional outputs}{

\enumerate{
\item If EACH_RUN_DIGEST = TRUE \cr
Creates and fills \strong{\emph{DIGEST}} folder for each run of the composite scenario with
all optional outputs of \code{\link{run_isobxr}} function. \cr
(folder name structure: \strong{\emph{CPS + SERIES_ID + YYY + XXXX + DIGEST}})
\item If to_CPS_DIGEST_CSVs = TRUE \cr
In the \strong{\emph{0_CPS_DIGEST}} folder,
edits csv versions of the whole-composite scenario evD and evS datasets. \cr
(file names structures: \strong{\emph{CPS + SERIES_ID + YYY + evD.csv}}
and \strong{\emph{CPS + SERIES_ID + YYY + evS.csv}})
}
}

\examples{
# Example 1: Changing intensity of fluxes
# for more information see tutorial at
# https://ttacail.github.io/isobxr_web/vgn_06_compose_isobxr_tutorial.html#34_Run_outputs

# This is an example using the tutorial files embedded in package data
# It can be run as such.
compose_isobxr(workdir = "/Users/username/Documents/1_ABC_tutorial",
               SERIES_ID = "ABC_change_balance", # name of the series ID
               time_units = c("d", "d"), # in/out time units for pdf plots
               COMPO_MASTER = "0_CPS_MASTER_changing_balance.xlsx",
               plot_HIDE_BOXES_delta = c("SINK"), # hide in delta plots
               plot_HIDE_BOXES_size = c("SOURCE", "SINK"), # hide in size plots
               EACH_RUN_DIGEST = FALSE, # do not export the DIGEST for each run
               to_CPS_DIGEST_CSVs = FALSE) # do not export whole model to CSVs

}
\seealso{
Documentation on \code{\link{run_isobxr}}
}
