% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/classification.R
\name{classification_agreement_index}
\alias{classification_agreement_index}
\title{Calculate agreement index}
\usage{
classification_agreement_index(
  true_score,
  estimated_score,
  cut_scores,
  cat_labels = NULL
)
}
\arguments{
\item{true_score}{A numeric vector of examinees' true score values.
Values can be in theta scale or summed scores.}

\item{estimated_score}{A numeric vector of examinees' estimated score values.
Values can be in theta scale or summed scores.}

\item{cut_scores}{A sorted (ascending order) numeric vector of  cut score
values. Values can be in theta scale or summed scores. Do not include 0 or
the maximum possible score of the test.}

\item{cat_labels}{A string vector representing the labels of the categories.
The length of the vector should be one more than the length of the
cut scores. The default value is \code{NULL} where the categories will be
labeled as 1, 2, ..., (number of cut scores plus one). For example, if
there are three cut scores category labels can be:
\code{c("Unsatisfactory", "Basic", "Mastery", "Advanced")}.}
}
\value{
A list of following elements:
  \describe{
    \item{\code{ca_table}}{A classification table where rows are true
      categories and columns are estimated categories. The values are the
      number of examinees.}
    \item{\code{ca_table}}{A classification table where rows are true
      categories and columns are estimated categories. The values are the
      proportion of examinees.}
    \item{\code{ca}}{Classification agreement index}
  }
}
\description{
Calculate agreement index
}
\examples{

ip <- generate_ip(model = sample(c("GPCM", "2PL"), 20, TRUE))
n_examinee <- 1000
true_theta <- rnorm(n_examinee)
observed_theta <- true_theta + runif(n_examinee, -.5, .5)
theta_cs <- c(-1, 0, 1.5)
raw_cs <- round(rsss(ip = ip, scale_score = theta_cs))
true_raw_score <- round(rsss(ip = ip, scale_score = true_theta))
observed_raw_score <- round(rsss(ip = ip, scale_score = observed_theta))

# Theta scores
classification_agreement_index(true_score = true_theta,
                               estimated_score = observed_theta,
                               cut_scores = theta_cs)
# Summed scores
classification_agreement_index(true_score = true_raw_score,
                               estimated_score = observed_raw_score,
                               cut_scores = raw_cs)
# Add labels
classification_agreement_index(true_score = true_theta,
                               estimated_score = observed_theta,
                               cut_scores = theta_cs,
                               cat_labels = c("Unsatisfactory", "Basic",
                                              "Mastery", "Advanced"))

}
\author{
Emre Gonulates
}
