% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/api_define_extract.R
\name{remove_from_extract.micro_extract}
\alias{remove_from_extract.micro_extract}
\title{Remove values from an existing extract definition for an IPUMS microdata
project}
\usage{
\method{remove_from_extract}{micro_extract}(extract, samples = NULL, variables = NULL, ...)
}
\arguments{
\item{extract}{An \code{\link[=ipums_extract-class]{ipums_extract}} object.}

\item{samples}{Character vector of sample names to remove from the extract
definition.}

\item{variables}{Names of the variables to remove from the extract
definition. All variable-specific fields for the indicated variables
will also be removed.}

\item{...}{Ignored}
}
\value{
A modified \code{micro_extract} object
}
\description{
\ifelse{html}{\href{https://lifecycle.r-lib.org/articles/stages.html#experimental}{\figure{lifecycle-experimental.svg}{options: alt='[Experimental]'}}}{\strong{[Experimental]}}

Remove existing values from an IPUMS microdata extract definition. All
fields are optional, and if omitted, will be unchanged.

This function is marked as experimental because it is typically not the best
option for maintaining reproducible extract definitions and may be retired
in the future. For reproducibility, users should strive to build extract
definitions with \code{\link[=define_extract-micro]{define_extract_*()}} functions.

If you have a complicated extract definition to revise, but do not have
the original extract definition code that created it, we suggest that you
save the revised extract as a JSON file with \code{\link[=save_extract_as_json]{save_extract_as_json()}}. This
will create a stable version of the extract definition that
can be used in the future as needed.

To add new values to an IPUMS microdata extract definition, see
\code{\link[=add_to_extract.micro_extract]{add_to_extract()}}.

Learn more about the IPUMS API in \code{vignette("ipums-api")}.
}
\details{
If the supplied extract definition comes from
a previously submitted extract request, this function will reset the
definition to an unsubmitted state.

To retain a variable while modifying its particular specifications, first
remove that variable, then add a new specification using \code{add_to_extract()}.
}
\examples{
usa_extract <- define_extract_usa(
  description = "USA example",
  samples = c("us2013a", "us2014a"),
  variables = list(
    var_spec("AGE", data_quality_flags = TRUE),
    var_spec("SEX", case_selections = "1"),
    "RACE"
  )
)

# Providing names of samples or variables will remove them and
# all of their associated specifications from the extract:
remove_from_extract(
  usa_extract,
  samples = "us2014a",
  variables = c("AGE", "RACE")
)

# To remove detailed specifications from a variable, indicate the
# specifications to remove within `var_spec()`. The
# named variable will be retained in the extract, but modified by
# removing the indicated specifications.
remove_from_extract(
  usa_extract,
  variables = var_spec("SEX", case_selections = "1")
)

# To make multiple modifications, use a list of `var_spec()` objects.
remove_from_extract(
  usa_extract,
  variables = list(
    var_spec("SEX", case_selections = "1"),
    var_spec("AGE")
  )
)
}
\seealso{
\code{\link[=add_to_extract.micro_extract]{add_to_extract()}} to add values
to an extract definition.

\code{\link[=submit_extract]{submit_extract()}} and \code{\link[=download_extract]{download_extract()}} to submit and process an
extract request.

\code{\link[=define_extract-micro]{define_extract_*()}} to create a new extract
definition from scratch.
}
\keyword{internal}
