% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.R
\name{lbl_define}
\alias{lbl_define}
\title{Define labels for an unlabelled vector}
\usage{
lbl_define(x, ...)
}
\arguments{
\item{x}{An unlabelled vector}

\item{...}{Arbitrary number of two-sided formulas.

The left hand side should be a label placeholder created with \code{\link[=lbl]{lbl()}}.

The right hand side should be a function taking \code{.val} that
evaluates to \code{TRUE} for all cases that should receive the label specified
on the left hand side.

Can be provided as an anonymous function or formula. See Details section.}
}
\value{
A \code{\link[haven:labelled]{labelled}} vector
}
\description{
Create a \code{\link[haven:labelled]{labelled}} vector from an unlabelled
vector using \code{\link[=lbl_relabel]{lbl_relabel()}} syntax, allowing for the grouping of multiple
values into a single label. Values not assigned a label remain unlabelled.
}
\details{
Several \verb{lbl_*()} functions include arguments that can be passed a function
of \code{.val} and/or \code{.lbl}. These refer to the existing values and
labels in the input vector, respectively.

Use \code{.val} to refer to the \emph{values} in the vector's value labels.
Use \code{.lbl} to refer to the \emph{label names} in the vector's value labels.

Note that not all \verb{lbl_*()} functions support both of these arguments.
}
\examples{
age <- c(10, 12, 16, 18, 20, 22, 25, 27)

# Group age values into two label groups.
# Values not captured by the right hand side functions remain unlabelled
lbl_define(
  age,
  lbl(1, "Pre-college age") ~ .val < 18,
  lbl(2, "College age") ~ .val >= 18 & .val <= 22
)
}
\seealso{
Other lbl_helpers: 
\code{\link{lbl_add}()},
\code{\link{lbl_clean}()},
\code{\link{lbl_na_if}()},
\code{\link{lbl_relabel}()},
\code{\link{lbl}()},
\code{\link{zap_ipums_attributes}()}
}
\concept{lbl_helpers}
