% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/lbl_helpers.r
\name{lbl_add}
\alias{lbl_add}
\alias{lbl_add_vals}
\title{Add labels for unlabelled values}
\usage{
lbl_add(x, ...)

lbl_add_vals(x, labeller = as.character, vals = NULL)
}
\arguments{
\item{x}{A \code{\link[haven]{labelled}} vector}

\item{...}{Labels formed by \code{\link{lbl}} indicating the value and label to be added.}

\item{labeller}{A function that takes a single argument of the values and returns the
labels. Defaults to \code{as.character}. \code{\link[rlang]{as_function}}, so
also accepts quosure-style lambda functions. See examples for more details.}

\item{vals}{Vector of values to be labelled. NULL, the default labels all values
that are in the data, but aren't already labelled.}
}
\value{
A haven::labeled vector
}
\description{
Add labels for values that don't already have them.
}
\examples{
x <- haven::labelled(
  c(100, 200, 105, 990, 999, 230),
  c(`Unknown` = 990, NIU = 999)
)

lbl_add(x, lbl(100, "$100"), lbl(105, "$105"), lbl(200, "$200"), lbl(230, "$230"))

lbl_add_vals(x)
lbl_add_vals(x, ~paste0("$", .))
lbl_add_vals(x, vals = c(100, 200))

}
\seealso{
Other lbl_helpers: \code{\link{lbl_clean}},
  \code{\link{lbl_collapse}}, \code{\link{lbl_na_if}},
  \code{\link{lbl_relabel}}, \code{\link{lbl}},
  \code{\link{zap_ipums_attributes}}
}
