% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/internal-lin_alg.R, R/utils-export.R
\name{is_conv_to_asymptotic}
\alias{is_conv_to_asymptotic}
\alias{conv_plot}
\alias{conv_plot.ipmr_ipm}
\title{Check for model convergence to asymptotic dynamics}
\usage{
is_conv_to_asymptotic(ipm, tolerance)

conv_plot(ipm, iterations, log, show_stable, ...)

\method{conv_plot}{ipmr_ipm}(ipm, iterations = NULL, log = FALSE, show_stable = TRUE, ...)
}
\arguments{
\item{ipm}{An object returned by \code{make_ipm()}.}

\item{tolerance}{The tolerance for convergence.}

\item{iterations}{The range of iterations to plot \code{lambda} for. The default
is every iteration.}

\item{log}{A logical indicating whether log transform \code{lambda}.}

\item{show_stable}{A logical indicating whether or not to draw a line indicating
population stability at \code{lambda = 1}.}

\item{...}{Further arguments to \code{plot}.}
}
\value{
\code{is_conv_to_asymptotic}: Either \code{TRUE} or \code{FALSE}.
\code{conv_plot}: code{ipm} invisibly.
}
\description{
Checks for convergence to asymptotic dynamics numerically and
visually. \code{is_conv_to_asymptotic} checks whether
\code{lambda[iterations - 1]} equals \code{lambda[iterations]} within the
specified tolerance, \code{tolerance}. \code{conv_plot} plots the time series of
\code{lambda} (or \code{log(lambda)}.
}
\details{
Plotting can be controlled by passing additional graphing parameters
to \code{...}.
}
\examples{
data(gen_di_det_ex)

proto <- gen_di_det_ex$proto_ipm \%>\%
  define_pop_state(n_ht = runif(200),
                   n_b  = 200000)

ipm <- make_ipm(proto)

is_conv_to_asymptotic(ipm, tol = 1e-5)
conv_plot(ipm)

}
