% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/ipft.R
\name{ipfKnn}
\alias{ipfKnn}
\title{This function implements the k-nearest neighbors algorithm}
\usage{
ipfKnn(train, test, k = 3, method = "euclidean", norm = 2, sd = 5,
  epsilon = 0.001, alpha = 1, threshold = 20, FUN = NULL, ...)
}
\arguments{
\item{train}{a data frame containing the RSSI vectors of the training set}

\item{test}{a data frame containing the RSSI vectors of the test set}

\item{k}{the k parameter for knn algorithm (number of nearest neighbors)}

\item{method}{the method to compute the distance between the RSSI vectors:
'euclidean', 'manhattan', 'norm', 'LGD' or 'PLGD'}

\item{norm}{parameter for the 'norm' method}

\item{sd}{parameter for 'LGD' and 'PLGD' methods}

\item{epsilon}{parameter for 'LGD' and 'PLGD' methods}

\item{alpha}{parameter for 'PLGD' method}

\item{threshold}{parameter for 'PLGD' method}

\item{FUN}{an alternative function provided to compute the distance.
This function must return a matrix of dimensions:
nrow(test) x nrow(train), containing the distances from
test observations to train observations. The two first parameters
taken by the function must be train and test}

\item{...}{additional parameters for provided function FUN}
}
\value{
An S4 class object of type ipfModel, with the following slots:
                 neighbors -> a matrix with k columns and nrow(test) rows, with the
                               k nearest neighbors for each test observation
                 weights ->    a matrix with k columns and nrow(test) rows, with the
                               weight for each neighbour
                 distances ->  a matrix with k columns and nrow(test) rows, with the
                               distances between test and each neighbour
                 k ->          k parameter
                 groups ->     the group index for each training observation
}
\description{
This function implements the k-nearest neighbors algorithm
}
\examples{

    model <- ipfKnn(ipftrain[, 1:168], ipftest[, 1:168], k = 9, method = 'manhattan')

}
