% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/conforming_vector_create.R
\name{conforming_vector_create}
\alias{conforming_vector_create}
\title{Create an empty conforming vector}
\usage{
conforming_vector_create(data_table)
}
\arguments{
\item{data_table}{A use table, Leontief-matrix, Leontief-inverse,
a coefficient matrix or other named matrix / vector.}
}
\value{
A wide-format conforming vector of data frame class, 
with column names matching the metadata of the \code{data_table}.
}
\description{
This helper function creates you a named vector that conforms your
analytical objects, such as the use table, the Leontief-matrix, 
etc. With 60x60 matrixes it is easy to make mistakes with manual 
definition. The empty effects vector can be used in \code{.csv} format
as a sample to import scenarios from a spreadsheet application.
}
\examples{
de_input_flow <- input_flow_get(data_table = iotable_get())

conforming_vector_create (data_table = de_input_flow)
}
\seealso{
Other iotables processing functions: 
\code{\link{household_column_get}()},
\code{\link{iotable_year_get}()},
\code{\link{key_column_create}()},
\code{\link{matrix_round}()},
\code{\link{output_get}()},
\code{\link{primary_input_get}()},
\code{\link{rows_add}()},
\code{\link{supplementary_add}()},
\code{\link{total_tax_add}()},
\code{\link{vector_transpose_longer}()},
\code{\link{vector_transpose_wider}()}
}
\concept{iotables processing functions}
