% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/airpol_get.R
\name{airpol_get}
\alias{airpol_get}
\title{Get air pollutant data}
\source{
Eurostat folder  
\href{https://ec.europa.eu/eurostat/web/products-datasets/-/env_ac_ainah_r2}{Air emissions accounts by NACE Rev. 2 activity}
}
\usage{
airpol_get(
  airpol = "GHG",
  geo = "BE",
  year = 2020,
  unit = "THS_T",
  data_directory = NULL,
  force_download = TRUE
)
}
\arguments{
\item{airpol}{The code of the air pollutant. Defaults \code{GHG}.
\code{ACG}, \code{CH4}, \code{CH4_CO2E}, \code{CH4_NMVOCE}, \code{CO}, \code{CO2}, 
\code{CO2_BIO}, \code{CO_NMVOCE}, \code{GHG}, \code{HFC_CO2E}, \code{N2O}, \code{N2O_CO2E}, 
\code{NF3_SF6_CO2E}, \code{NH3}, \code{NH3_SO2E}, \code{NMVOC}, \code{NOX}, \code{NOX_NMVOCE}, 
\code{NOX_SO2E}, \code{O3PR}, \code{PFC_CO2E}, \code{PM10}, \code{PM2_5}, \code{SOX_SO2E}.}

\item{geo}{The country code. The special value \code{'germany_1995'} will return the 
replication dataset \code{\link{germany_airpol}}.}

\item{year}{The year.  The average employment will be created for the given
year, starting with \code{2008}, when the NACE Rev 2 was introduced in 
employment statistics.}

\item{unit}{Defaults to \code{"THS_T"} (thousand tons.)}

\item{data_directory}{Defaults to \code{NULL}, if a valid directory, it will 
try to save the pre-processed data file here with labelling.}

\item{force_download}{Defaults to \code{TRUE}. If \code{FALSE} it will use the existing downloaded file
in the \code{data_directory} or the temporary directory, if it exists.}
}
\value{
A data.frame with auxiliary metadata to conform the symmetric
input-output tables.
}
\description{
Get air emissions accounts by NACE Rev. 2 activity for environmental impact
assessments.
}
\details{
Currently tested only with product x product tables. 
The dataset air emissions accounts by NACE Rev. 2 activity [env_ac_ainah_r2] has five dimensions:
The Air pollutant \code{airpol} variables are collected on the emissions of the following pollutants: 
carbon dioxide without emissions from biomass (CO2), carbon dioxide from biomass (Biomass CO2), 
nitroux oxide (N2O), methane (CH4), perfluorocarbons (PFCs), Hydrofluorocarbons (HFCs), 
sulphur hexafluoride (SF6) including nitrogen trifluoride (NF3), nitrogen oxides (NOx), 
Non-methane volatile organic compounds, (NMVOC), carbon monoxide (CO), 
Particulate matter smaller than 10 micrometre (PM10), Particulate matter smaller than 2,5 micrometre (PM2,5), 
Sulphur dioxide (SO2), Ammonia (NH3).

See \href{https://ec.europa.eu/eurostat/cache/metadata/en/env_ac_ainah_r2_sims.htm}{Reference Metadata in Single Integrated Metadata Structure (SIMS)}
for further details, particularly on the calculation of Global warming potential \code{GHG}, 
Acidifying gases \code{ACG} and Tropospheric ozone precursors \code{O3PR}.
}
\examples{
airpol_get(airpol = "CO2", geo="germany_1995", year = 1995, unit = "THS_T") 
}
\seealso{
Other import functions: 
\code{\link{employment_get}()},
\code{\link{iotables_download}()},
\code{\link{iotables_metadata_get}()},
\code{\link{iotables_read_tempdir}()}
}
\concept{import functions}
