% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/use_table_get.R
\name{use_table_get}
\alias{use_table_get}
\title{Create a use (input flow) matrix}
\usage{
use_table_get(source = "germany_1990", geo = "DE", year = 1990,
  unit = "MIO_EUR", stk_flow = "DOM", households = FALSE,
  keep_total = FALSE, labelling = "iotables")
}
\arguments{
\item{source}{A data source, for example "naio_10_cp1700". Possible codes are "naio_10_cp1700",
"naio_10_cp1750", "naio_10_pyp1700", "naio_10_pyp1750", "naio_cp17_r2", "naio_17_agg_60_r2", 
"naio_17_agg_10_r2", "croatia_2010_1700", "croatia_2010_1800", 
"croatia_2010_1900". For further information consult the 
\href{http://ec.europa.eu/eurostat/web/esa-supply-use-input-tables/methodology/symmetric-input-output-tables}{Eurostat Symmetric Input-Output Tables} page.}

\item{geo}{A country code or a country name.  For example, "SK" or as "Slovakia".}

\item{year}{A numeric variable containing the year. Defaults to 2010, because this year has the most data.}

\item{unit}{A character string containing the currency unit, defaults to "MIO_NAC" (million national currency unit). The alternative is "MIO_EUR".}

\item{stk_flow}{Defaults to "DOM", alternative "IMP".}

\item{households}{If you need to make household demand endogenous, or "close the households off", TRUE selects 
wages and final household consumption. This is needed for induced-effects calculations.}

\item{keep_total}{Logical variable. Defaults to FALSE and removes the totalling row and column from the matrix.}

\item{labelling}{Defaults to "iotables" which gives standard row and column names regardless of the
source of the table, or if it is a product x product, industry x industry or product x industry table.
The alternative is "short" which is the original short row or column code of Eurostat or OECD.}
}
\description{
The function invokes the \code{\link{iotable_get}} function and selects a national 
input-output table from the bulk downloaded file. If the file is not 
downloaded, it downloads it to the temporary directory.
}
\examples{
use_de <- use_table_get( source = "germany_1990", geo = 'DE', year = 1990,
                       unit = "MIO_EUR", labelling  = 'iotables')
\dontrun{
sk_use_1700_2 <- use_table_get2 ( source = "naio_10_cp1700", geo = "SK",
                                 year = 2010, unit = "MIO_EUR",
                                 stk_flow = "DOM", households = TRUE,
                                 keep_total = TRUE)
 }
}
