% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/output_get.R
\name{output_get}
\alias{output_get}
\title{Get an output vector}
\usage{
output_get(source = "germany_1990", geo = "DE", year = 1990,
  unit = "MIO_EUR", households = FALSE, labelling = "iotables",
  stk_flow = "DOM", keep_total = FALSE)
}
\arguments{
\item{source}{A data source, for example "naio_10_cp1700". Possible codes are "naio_10_cp1700",
"naio_10_cp1750", "naio_10_pyp1700", "naio_10_pyp1750", "naio_cp17_r2", "naio_17_agg_60_r2", 
"naio_17_agg_10_r2", "croatia_2010_1700", "croatia_2010_1800", 
"croatia_2010_1900". For further information consult the 
\href{http://ec.europa.eu/eurostat/web/esa-supply-use-input-tables/methodology/symmetric-input-output-tables}{Eurostat Symmetric Input-Output Tables} page.}

\item{geo}{A country code or a country name.  For example, "SK" or as "Slovakia".}

\item{year}{A numeric variable containing the year. Defaults to 2010, because this year has the most data.}

\item{unit}{A character string containing the currency unit, defaults to "MIO_NAC" (million national currency unit). The alternative is "MIO_EUR".}

\item{households}{If you need to make household demand endogenous, or "close the households off", TRUE selects 
wages and final household consumption. This is needed for induced-effects calculations.}

\item{labelling}{Defaults to "iotables" which gives standard row and column names regardless of the
source of the table, or if it is a product x product, industry x industry or product x industry table.
The alternative is "short" which is the original short row or column code of Eurostat or OECD.}

\item{stk_flow}{Defaults to "DOM", alternative "IMP".}

\item{keep_total}{Logical variable. Defaults to FALSE and removes the totaling row and column from the matrix.}
}
\description{
Get an output vector
}
\examples{
output_hr <- output_get(source = "croatia_2010_1800", geo = "HR",
                        year = 2010, unit = "T_NAC", labelling = "iotables")
}
