% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/interim.r
\name{recruitment}
\alias{recruitment}
\title{Scheduling interim analyses in clinical trials}
\usage{
recruitment(nc, ns, cw, sw, sf, tb, en)
}
\arguments{
\item{nc}{maximum number of centers to be opened or \code{Inf}.}

\item{ns}{maximum number of patients to be screened within each center or \code{Inf}.}

\item{cw}{number of center openings per week.}

\item{sw}{number of screened patients per week within each center.}

\item{sf}{screening failure rate.}

\item{tb}{time between screening and enrollment/randomization in weeks.}

\item{en}{number of patients to be enrolled.}
}
\value{
\code{recruitment} returns a list of vectors with the following components:
\itemize{
\item \code{weeksOfTrial} a vector counting the trial week for recruitment(from 0 (start of site openings) to the required number of weeks for recruitment)
\item \code{openCenters} a vector with the (cumulative) number of opened centers per trial week
\item \code{closedCenters} a vector with the (cumulative) number of closed centers per trial week
\item \code{centerWeeks} a vector with the (cumulative) number of opened center weeks per trial week
\item \code{screenings} a vector with the (cumulative) number of screened patients per trial week
\item \code{weeksOfEnrollment} a vector counting the weeks of enrollment (with start of site openings as reference start)
\item \code{enrollments} a vector with the (cumulative) number of enrolled/randomized patients per week of enrollment
}
}
\description{
Function \code{recruitment} simulates the recruitment of patients in clinical trials.
}
\details{
Function \code{recruitment} simulates the recruitment progress for a required
number of enrolled patients in clinical trials based on the expected number
of centers to be opened per week and the expected number of patients being recruited per site and week.
The function assumes that centers are being opened at a constant rate per week (\code{cw})
and patient per center are screened at a constant rate per week (\code{sw}).

The function can handle recruitment limits by limiting the total number of centers (\code{nc})
and/or the number of patients recruitable per site (\code{ns}).

The function discriminates between screening timepoint and enrollment/randomization timepoint by
allowing a screening period (\code{tb}) and screen failure rate (\code{sf}) to be specified.
If both are zero then patients are directly enrolled at screening.

Function \code{recruitment} can handle four different recruitment scenarios.

\itemize{
   \item Scenario 1. Centers are being opened over the entire trial duration,
i.e. no limit of centers (\code{nc=Inf}) and are kept open during the complete trial duration,
i.e. no limit of patients per center (\code{ns=Inf}).
   \item Scenario 2. Only a limited number of centers can be opened (\code{nc=} a positive number) and are
kept open during the complete trial duration (\code{ns=Inf}).
   \item Scenario 3. Centers are being opened over the entire trial duration (\code{nc=Ind}) and are
only have a limited capacity for patient recruitment (\code{ns=} a positive number).
   \item Scenario 4. Only a limited number of centers can be opened (\code{nc=} a positive number) and are
only have a limited capacity for patient recruitment (\code{ns=} a positive number).
}

Under scenario 4 only a limited number of patients can be recruited. The auxilliary function \code{capacity} can
be used to derive the maximum number of patients that can be enrolled under this scenario.

Results of \code{recruitment} are required as input for function \code{\link{treatment}} to derive
the time when treatment of patients is finished.
}
\examples{
x=recruitment(nc=Inf,ns=Inf,cw=4,sw=2,sf=0.3,tb=4,en=400)
}
\seealso{
\code{\link{treatment}} for simulating the treatment duration for a given recruitment scenario;
\code{\link{trialCourse}} for plots of recruitment and treatment scenarios;
\code{\link{capacity}} for deriving the maximum number of patients that can be enrolled under scenario 4;
}

