% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/utils-dataframe.R
\name{switch_pipeline}
\alias{switch_pipeline}
\title{Branch a \code{dplyr} pipeline based on a set of conditions}
\usage{
switch_pipeline(.x, ...)
}
\arguments{
\item{.x}{a dataframe}

\item{...}{a list of formulae of the type \verb{predicate ~ purrr function} using
\code{.x} as the single parameter}
}
\value{
the result of applying \verb{purrr function} to \code{.x} in the case where
\code{predicate} evaluates to true. Both predicate and function can refer to
the pipeline dataframe using \code{.x}
}
\description{
Branch a \code{dplyr} pipeline based on a set of conditions
}
\examples{

iris \%>\% switch_pipeline(
  is_col_present(.x, Species) ~ .x \%>\% dplyr::rename(new = Species)
) \%>\% dplyr::glimpse()
}
