# Generated by using Rcpp::compileAttributes() -> do not edit by hand
# Generator token: 10BE3573-1514-4C36-9D1C-5A225CD40393

#' This function obtains the correlation matrix of longitudinal data
#' @param y the longitudinal response.
#' @param x a matrix of predictors, consisting of omics and environment factors, as well as their interactions. In
#' the case study, the omics measurements are lipidomics data.
#' @param beta the coefficient vector.
#' @param n the sample size.
#' @param k a vector that contains the number of repeated measurements for each subject.
#' @param corre the working correlation structure that is used in estimation algorithm. interep provides three choices
#' for the working correlation structure: "a" as "AR-1", "i" as "independence" and "e" as "exchangeable".
#' @return the correlation matrix.
#' @examples
#' data("dat")
#' y=dat$y
#' n=dim(y)[1]
#' x=dat$x
#' data=reformat(y,x)
#' y=data$y
#' x=data$x
#' beta=dat$beta
#' corre='e'
#' k=rep(dat$k,n)
#' CorrR(y,x,beta,n,k,corre)
#' @export
CorrR <- function(y, x, beta, n, k, corre) {
    .Call(`_interep_CorrR`, y, x, beta, n, k, corre)
}

ScoreU <- function(n, k, y, x, p, beta, Rhat) {
    .Call(`_interep_ScoreU`, n, k, y, x, p, beta, Rhat)
}

#' This function obtains the first derivative function of MCP (Minimax Concave Penalty)
#' @param theta a coefficient vector.
#' @param lambda the tuning parameter.
#' @param gamma the regularization parameter in MCP (Minimax Concave Penalty).
#' It balances between the unbiasedness and concavity of MCP.
#' @return the first derivative of MCP function.
#' @details
#' Rigorously speaking, the regularization parametre \eqn{\gamma} needs to be obtained via a data-driven approach.
#' Published studies suggest experimenting with a few values, such as 1.8, 3, 4.5, 6, and 10, then fixing its value. In our numerical
#' study, we have examined this sequence and found that the results are not sensitive to the choice of value of \eqn{\gamma},
#' and set the value at 3. In practice, to be prudent, values other than 3 should also be investigated.
#'
#' @examples
#' theta=runif(20,-5,5)
#' lambda=1
#' gamma=3
#' dmcp(theta,lambda,gamma)
#' @export
dmcp <- function(theta, lambda, gamma) {
    .Call(`_interep_dmcp`, theta, lambda, gamma)
}

#' fit a generalized estimating equation with given lambda
#'
#' This function makes predictions for generalized estimating equation with a given value of lambda.
#' Typical usage is to have the cv.interep function compute the optimal lambda, then provide it to
#' the interep function.
#' @param e matrix of environment factors.
#' @param z matrix of omics factors. In the case study, the omics measurements are lipidomics data.
#' @param y0 the longitudinal response.
#' @param beta the intial value for the coefficient vector.
#' @param lam1 the tuning parameter lambda1 for individual predictors.
#' @param lam2 the tuning parameter lambda2 for interactions.
#' @param corre the working correlation structure that is used in estimation algorithm. interep provides three choices
#' for the working correlation structure: "a" as "AR-1", "i" as "independence" and "e" as "exchangeable".
#' @param maxits the maximum number of iterations that is used in the estimation algorithm.
#' @details
#' When dealing with predictors with both main effects and interactions, this function requires two optimal tuning parameters,
#' \eqn{\lambda_{1}} and \eqn{\lambda_{2}}; when there are only main effects in the predictors, this function only requires \eqn{\lambda_{1}},
#' @return
#' \item{coef}{the coefficient vector.}
#' @references
#' Zhou, F., Ren, J., Li X., Wang, W., Jiang, Y. and Wu, C. (2018+). Variable selection for interactions in longitudinal lipidomics studies.
#'
#' Wu, C., Zhong, P. & Cui, Y. (2018). Additive varying-coefficient model for nonlinear gene-environment interactions.
#' \href{https://doi.org/10.1515/sagmb-2017-0008}{\emph{Statistical Applications in Genetics and Molecular Biology}, 17(2)}
#'
#' Wu, C., Jiang, Y., Ren, J., Cui, Y. and Ma, S. (2018). Dissecting gene-environment interactions: a penalized robust approach accounting for hierarchical structures.
#' \href{https://doi.org/10.1002/sim.7518}{\emph{Statistics in Medicine}, 37:437–456}
#'
#' Wu, C., Shi, X., Cui, Y. and Ma, S. (2015) A penalized robust semiparametric approach for gene-environment interactions.
#' \href{https://doi.org/10.1002/sim.6609}{\emph{Statistics in Medicine}, 34 (30): 4016–4030}
#'
#' Wu, C., Cui, Y. and Ma, S. (2014) Integrative analysis of gene-environment interactions under a multi-response partially linear varying coefficient model.
#' \href{https://doi.org/10.1002/sim.6287}{\emph{Statistics in Medicine}, 33 (28): 4988–4498}
#'
#' Wu, C. and Cui Y. (2013) A novel method for identifying nonlinear gene-environment interactions in case-control association studies.
#' \href{https://doi.org/10.1007/s00439-013-1350-z}{\emph{Human Genetics}, 132 (12): 1413–1425}
#'
#' @examples
#' data("dat")
#' e=dat$e
#' z=dat$z
#' y=dat$y
#' beta=dat$beta
#' lam1=dat$lam1
#' lam2=dat$lam2
#' index=dat$index
#' b = interep(e, z, y, beta, lam1, lam2, corre='e',maxits=30)
#' b[abs(b)<0.05]=0
#' pos = which(b != 0)
#' tp = length(intersect(index, pos))
#' fp = length(pos) - tp
#' list(tp=tp, fp=fp)
#'
#' @export
interep <- function(e, z, y0, beta, lam1, lam2, corre, maxits) {
    .Call(`_interep_interep`, e, z, y0, beta, lam1, lam2, corre, maxits)
}

#' This function changes the format of the longitudinal data from wide format to long format
#' @param y the longitudinal response.
#' @param x a matrix of predictors, consisting of omics and environment factors, as well as their interactions. In
#' the case study, the omics measurements are lipidomics data.
#'
#' @examples
#' data("dat")
#' y=dat$y
#' x=dat$x
#' reformat(y,x)
#' @export
reformat <- function(y, x) {
    .Call(`_interep_reformat`, y, x)
}

