% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/inter_bch.R
\name{inter_bch}
\alias{inter_bch}
\title{Fits promotion time cure rate model for interval censored data}
\usage{
inter_bch(dataset, left, right, cov, sigma = 10, crit_theta = 0.001,
  crit_p = 0.005, max_n = 100, output_files = FALSE)
}
\arguments{
\item{dataset}{Dataset used to fit the model.}

\item{left}{Vector containing the last check times before event.}

\item{right}{Vector containing the first check times after event.}

\item{cov}{String vector containing the column names to be used on the
cure rate predictor.}

\item{sigma}{Parameter for the primal-dual interior-point algorithm used on
the maximization process. Default value set to 10.}

\item{crit_theta}{The effects minimum error for convergence purposes.}

\item{crit_p}{Minimum error of the non-parametric cumulative distribution function.}

\item{max_n}{Maximum number of iterations of the ECM algorithm.}

\item{output_files}{Boolean indicating if text outputs for the estimates and
variances should be generated.}
}
\value{
The \code{inter_bch} function returns an list containing the
  following outputs:
  \item{\code{par}}{estimates of theta parameters.}
  \item{\code{mcov}}{estimates for the asymptotic covariance
  matrix of theta parameters.}
  \item{\code{stop_c}}{stop criteria
  indicator assuming 1 when process is stopped for a non-convergence
  criteria. Assumes 0 when convergence is reached.}
}
\description{
\code{inter_bch} returns a list with the estimated parameters \code{par} and
their asymptotic covariance matrix \code{mcov}. The list also contains a
dummy variable \code{stop_c} assuming 0 if algorithm converged and 1 if a
stop criteria ended the process.
}
\examples{
set.seed(3)
sample_set <- sim_bch(80)

## few iterations just to check how to use the function

inter_bch(sample_set, sample_set$L,
sample_set$R, c("xi1","xi2"), max_n = 5)

## precise estimate (computationally intensive)
\dontrun{

inter_bch(sample_set, sample_set$L, sample_set$R, c("xi1","xi2"))
}
}

