% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/rmse.R
\name{rmse}
\alias{rmse}
\title{Root Mean Squared Error}
\usage{
rmse(object, data)
}
\arguments{
\item{object}{fitted model}

\item{data}{data.frame (defaults to NULL)}
}
\value{
numeric value
}
\description{
Compute root mean squared error.
}
\details{
The RMSE is the square root of the average of squared differences
  between prediction and actual observation and indicates
  the absolute fit of the model to the data. It can be interpreted as the standard
  deviation of the unexplained variance, and is in the same units as the
  response variable. Lower values indicate better model fit.
}
\examples{
x <- glm(nclaims ~ area, offset = log(exposure), family = poisson(), data = MTPL2)
rmse(x, MTPL2)

}
\author{
Martin Haringa
}
