% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/is_nested_models.R
\name{is_nested_models}
\alias{is_nested_models}
\title{Checks whether a list of models are nested models}
\usage{
is_nested_models(...)
}
\arguments{
\item{...}{Multiple regression model objects.}
}
\value{
\code{TRUE} if models are nested, \code{FALSE} otherwise. If models
are nested, also returns two attributes that indicate whether nesting of
models is in decreasing or increasing order.
}
\description{
Checks whether a list of models are nested models, strictly
following the order they were passed to the function.
}
\examples{
m1 <- lm(Sepal.Length ~ Petal.Width + Species, data = iris)
m2 <- lm(Sepal.Length ~ Species, data = iris)
m3 <- lm(Sepal.Length ~ Petal.Width, data = iris)
m4 <- lm(Sepal.Length ~ 1, data = iris)

is_nested_models(m1, m2, m4)
is_nested_models(m4, m2, m1)
is_nested_models(m1, m2, m3)
}
