% Generated by roxygen2: do not edit by hand
% Please edit documentation in R/deploy.R
\name{deploy}
\alias{deploy}
\title{Deploy the Shiny App}
\usage{
deploy(
  directory = "/srv/shiny-server",
  app_name = "insane",
  demo = FALSE,
  overwrite = FALSE
)
}
\arguments{
\item{directory}{[\link{character}] A character vector of one path to the new location.}

\item{app_name}{[\link{character}] A character vector defining the shiny application name in the new location.}

\item{demo}{[\link{logical}] A logical indicating if examples spreadsheets should be copied in the app.}

\item{overwrite}{[\link{logical}] A logical indicating if existing destination files should be overwritten.}
}
\value{
[\link{logical}] A logical indicating whether the deployment is successfull (\code{TRUE}) or not (\code{FALSE}).
}
\description{
Deploy (copy) the shiny application to the specified directory
}
\examples{

deploy(directory = ".")

if (interactive()) {
  shiny::runApp("insane")
}

}
